/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ConfigUtils;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

@EventBusSubscriber(modid="onekeyminer")
public class ModCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"excavation").then(Commands.literal((String)"status").executes(ModCommands::showStatus))).then(Commands.literal((String)"help").executes(ModCommands::showHelp))).then(((LiteralArgumentBuilder)Commands.literal((String)"common").requires(source -> source.hasPermission(2))).then(ModCommands.registerCommonConfigCommands()))).then(Commands.literal((String)"client").then(ModCommands.registerClientConfigCommands()))).then(((LiteralArgumentBuilder)Commands.literal((String)"server").requires(source -> source.hasPermission(4))).then(ModCommands.registerServerConfigCommands()))).executes(ModCommands::showHelp));
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.translatable((String)"command.onekeyminer.help.title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.onekeyminer.help.status"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.onekeyminer.help.server"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.onekeyminer.help.client"), false);
        return 1;
    }

    private static int showStatus(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)((CommandSourceStack)context.getSource()).getEntity();
            boolean chainActive = ChainModeCapability.isChainModeActive((Player)player);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.onekeyminer.status", (Object[])new Object[]{Component.translatable((String)(chainActive ? "command.onekeyminer.status.on" : "command.onekeyminer.status.off"))}), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.onekeyminer.status.maxblocks", (Object[])new Object[]{CommonConfig.INSTANCE.maxBlocksInChain.get()}), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.onekeyminer.status.maxdepth", (Object[])new Object[]{CommonConfig.INSTANCE.maxChainDepth.get()}), false);
            boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.onekeyminer.status.diagonal", (Object[])new Object[]{Component.translatable((String)(diagonal ? "command.onekeyminer.enabled" : "command.onekeyminer.disabled"))}), false);
            boolean requireSneaking = (Boolean)CommonConfig.INSTANCE.requireSneaking.get();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.onekeyminer.status.sneaking", (Object[])new Object[]{Component.translatable((String)(requireSneaking ? "command.onekeyminer.required" : "command.onekeyminer.not_required"))}), false);
            return 1;
        }
        return 0;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerCommonConfigCommands() {
        LiteralArgumentBuilder builder = Commands.literal((String)"options");
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"maxChainBlocks").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSourceStack>)ctx, "maxChainBlocks", CommonConfig.INSTANCE.maxChainBlocks.get()))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4096)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSourceStack>)ctx, "maxChainBlocks", CommonConfig.INSTANCE.maxChainBlocks, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"maxChainDepth").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSourceStack>)ctx, "maxChainDepth", CommonConfig.INSTANCE.maxChainDepth.get()))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSourceStack>)ctx, "maxChainDepth", CommonConfig.INSTANCE.maxChainDepth, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"maxBlocksInChain").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSourceStack>)ctx, "maxBlocksInChain", CommonConfig.INSTANCE.maxBlocksInChain.get()))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4096)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSourceStack>)ctx, "maxBlocksInChain", CommonConfig.INSTANCE.maxBlocksInChain, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"maxBlocksInChainCreative").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSourceStack>)ctx, "maxBlocksInChainCreative", CommonConfig.INSTANCE.maxBlocksInChainCreative.get()))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSourceStack>)ctx, "maxBlocksInChainCreative", CommonConfig.INSTANCE.maxBlocksInChainCreative, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nonChainableBlocks").then(Commands.literal((String)"list").executes(ModCommands::listNonChainableBlocks))).then(Commands.literal((String)"add").then(Commands.argument((String)"blockId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.addToNonChainableBlocks((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"blockId")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"blockId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.removeFromNonChainableBlocks((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"blockId"))))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"seedBlacklist").then(Commands.literal((String)"list").executes(ModCommands::listSeedBlacklist))).then(Commands.literal((String)"add").then(Commands.argument((String)"seedId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.addToSeedBlacklist((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"seedId")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"seedId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.removeFromSeedBlacklist((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"seedId"))))));
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "enableDiagonalChaining", CommonConfig.INSTANCE.enableDiagonalChaining);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "teleportDropsToPlayer", CommonConfig.INSTANCE.teleportDropsToPlayer);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "ignoreToolCompatibility", CommonConfig.INSTANCE.ignoreToolCompatibility);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "matchBlockState", CommonConfig.INSTANCE.matchBlockState);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "matchSeedBlockState", CommonConfig.INSTANCE.matchseedBlockState);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "enableInCreative", CommonConfig.INSTANCE.enableInCreative);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "requireSneaking", CommonConfig.INSTANCE.requireSneaking);
        return builder;
    }

    private static void addBooleanConfigOption(LiteralArgumentBuilder<CommandSourceStack> builder, String optionName, ModConfigSpec.BooleanValue configValue) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)optionName).executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSourceStack>)ctx, optionName, configValue.get()))).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ModCommands.setCommonConfigBoolValue((CommandContext<CommandSourceStack>)ctx, optionName, configValue, BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))));
    }

    private static int showCommonConfigValue(CommandContext<CommandSourceStack> context, String name, Object value) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.value", (Object[])new Object[]{name, value}));
        return 1;
    }

    private static int setCommonConfigIntValue(CommandContext<CommandSourceStack> context, String name, ModConfigSpec.IntValue configValue, int newValue) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        configValue.set((Object)newValue);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.set.int", (Object[])new Object[]{name, newValue}));
        return 1;
    }

    private static int setCommonConfigBoolValue(CommandContext<CommandSourceStack> context, String name, ModConfigSpec.BooleanValue configValue, boolean newValue) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        configValue.set((Object)newValue);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        String status = newValue ? Component.translatable((String)"command.onekeyminer.enabled").getString() : Component.translatable((String)"command.onekeyminer.disabled").getString();
        player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.set.bool", (Object[])new Object[]{name, status}));
        return 1;
    }

    private static int listNonChainableBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        List blocks = (List)CommonConfig.INSTANCE.nonChainableBlocks.get();
        player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.blacklist.blocks.title"));
        if (blocks.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.list.empty"));
        } else {
            for (String block : blocks) {
                player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.list.item", (Object[])new Object[]{block}));
            }
        }
        return 1;
    }

    private static int addToNonChainableBlocks(CommandContext<CommandSourceStack> context, String blockId) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ArrayList<Object> blocks = new ArrayList<Object>((Collection)CommonConfig.INSTANCE.nonChainableBlocks.get());
        if (!((String)blockId).contains(":")) {
            blockId = "minecraft:" + (String)blockId;
        }
        if (blocks.contains(blockId)) {
            player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.blacklist.block.exists", (Object[])new Object[]{blockId}));
            return 0;
        }
        blocks.add(blockId);
        CommonConfig.INSTANCE.nonChainableBlocks.set(blocks);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.blacklist.block.added", (Object[])new Object[]{blockId}));
        return 1;
    }

    private static int removeFromNonChainableBlocks(CommandContext<CommandSourceStack> context, String blockId) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ArrayList blocks = new ArrayList((Collection)CommonConfig.INSTANCE.nonChainableBlocks.get());
        if (!((String)blockId).contains(":")) {
            blockId = "minecraft:" + (String)blockId;
        }
        if (!blocks.contains(blockId)) {
            player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.blacklist.block.not_exists", (Object[])new Object[]{blockId}));
            return 0;
        }
        blocks.remove(blockId);
        CommonConfig.INSTANCE.nonChainableBlocks.set(blocks);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.blacklist.block.removed", (Object[])new Object[]{blockId}));
        return 1;
    }

    private static int listSeedBlacklist(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        List seeds = (List)CommonConfig.INSTANCE.seedBlacklist.get();
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7e\u4e0d\u53ef\u8fde\u9501\u79cd\u690d\u7684\u79cd\u5b50\u5217\u8868\uff1a"));
        if (seeds.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"  \u00a77(\u5217\u8868\u4e3a\u7a7a)"));
        } else {
            for (String seed : seeds) {
                player.sendSystemMessage((Component)Component.literal((String)("  \u00a77- \u00a7r" + seed)));
            }
        }
        return 1;
    }

    private static int addToSeedBlacklist(CommandContext<CommandSourceStack> context, String seedId) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ArrayList<Object> seeds = new ArrayList<Object>((Collection)CommonConfig.INSTANCE.seedBlacklist.get());
        if (!((String)seedId).contains(":")) {
            seedId = "minecraft:" + (String)seedId;
        }
        if (seeds.contains(seedId)) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u79cd\u5b50 " + (String)seedId + " \u5df2\u5728\u9ed1\u540d\u5355\u4e2d")));
            return 0;
        }
        seeds.add(seedId);
        CommonConfig.INSTANCE.seedBlacklist.set(seeds);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.sendSystemMessage((Component)Component.literal((String)("\u00a7a\u5df2\u5c06 " + (String)seedId + " \u6dfb\u52a0\u5230\u4e0d\u53ef\u8fde\u9501\u79cd\u690d\u5217\u8868")));
        return 1;
    }

    private static int removeFromSeedBlacklist(CommandContext<CommandSourceStack> context, String seedId) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ArrayList seeds = new ArrayList((Collection)CommonConfig.INSTANCE.seedBlacklist.get());
        if (!((String)seedId).contains(":")) {
            seedId = "minecraft:" + (String)seedId;
        }
        if (!seeds.contains(seedId)) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u79cd\u5b50 " + (String)seedId + " \u4e0d\u5728\u9ed1\u540d\u5355\u4e2d")));
            return 0;
        }
        seeds.remove(seedId);
        CommonConfig.INSTANCE.seedBlacklist.set(seeds);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.sendSystemMessage((Component)Component.literal((String)("\u00a7a\u5df2\u4ece\u4e0d\u53ef\u8fde\u9501\u79cd\u690d\u5217\u8868\u4e2d\u79fb\u9664 " + (String)seedId)));
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerClientConfigCommands() {
        LiteralArgumentBuilder builder = Commands.literal((String)"options");
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSourceStack>)builder, "showBlockCount", ClientConfig.INSTANCE.showBlockCount);
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"messageStyle").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSourceStack>)ctx, "messageStyle", ClientConfig.INSTANCE.messageStyle.get()))).then(Commands.argument((String)"style", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionBuilder) -> {
            for (String style : Arrays.asList("chat", "actionbar", "both", "none")) {
                if (!style.startsWith(suggestionBuilder.getRemaining().toLowerCase())) continue;
                suggestionBuilder.suggest(style);
            }
            return suggestionBuilder.buildFuture();
        }).executes(ctx -> {
            String style = StringArgumentType.getString((CommandContext)ctx, (String)"style");
            if (Arrays.asList("chat", "actionbar", "both", "none").contains(style)) {
                ClientConfig.INSTANCE.messageStyle.set((Object)style);
                ConfigUtils.saveConfig(ClientConfig.SPEC);
                ((CommandSourceStack)ctx.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.messagestyle.set", (Object[])new Object[]{style}));
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.invalid_option"));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"keyMode").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSourceStack>)ctx, "keyMode", ClientConfig.INSTANCE.requireKeyHold.get()))).then(Commands.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionBuilder) -> {
            for (String mode : Arrays.asList("toggle", "hold")) {
                if (!mode.startsWith(suggestionBuilder.getRemaining().toLowerCase())) continue;
                suggestionBuilder.suggest(mode);
            }
            return suggestionBuilder.buildFuture();
        }).executes(ctx -> {
            String mode = StringArgumentType.getString((CommandContext)ctx, (String)"mode");
            if (Arrays.asList("toggle", "hold").contains(mode)) {
                ClientConfig.INSTANCE.requireKeyHold.set((Object)mode.equals("hold"));
                ConfigUtils.saveConfig(ClientConfig.SPEC);
                ((CommandSourceStack)ctx.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.keyhold.set", (Object[])new Object[]{mode}));
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.invalid_option"));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"Debug").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSourceStack>)ctx, "Debug", ClientConfig.INSTANCE.Debug.get()))).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ModCommands.setCommonConfigBoolValue((CommandContext<CommandSourceStack>)ctx, "Debug", ClientConfig.INSTANCE.Debug, BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"frozen timer").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSourceStack>)ctx, "frozen timer", ClientConfig.INSTANCE.frozentimer.get()))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Short.MAX_VALUE)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSourceStack>)ctx, "frozen timer", ClientConfig.INSTANCE.frozentimer, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerServerConfigCommands() {
        LiteralArgumentBuilder builder = Commands.literal((String)"options");
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"toolDurabilityThreshold").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSourceStack>)ctx, "toolDurabilityThreshold", ServerConfig.INSTANCE.toolDurabilityThreshold.get()))).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1000.0)).executes(ctx -> {
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            ServerConfig.INSTANCE.toolDurabilityThreshold.set((Object)value);
            ConfigUtils.saveConfig(ServerConfig.SPEC);
            ((CommandSourceStack)ctx.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.tool_durability.set", (Object[])new Object[]{value}));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"hungerThreshold").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSourceStack>)ctx, "hungerThreshold", ServerConfig.INSTANCE.hungerThreshold.get()))).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)20.0)).executes(ctx -> {
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            ServerConfig.INSTANCE.hungerThreshold.set((Object)value);
            ConfigUtils.saveConfig(ServerConfig.SPEC);
            ((CommandSourceStack)ctx.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.hunger.set", (Object[])new Object[]{value}));
            return 1;
        })));
        return builder;
    }

    private static int showConfigValue(CommandContext<CommandSourceStack> context, String name, Object value) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        player.sendSystemMessage((Component)Component.translatable((String)"command.onekeyminer.config.value", (Object[])new Object[]{name, value}));
        return 1;
    }
}

