/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.BlocksMinedPacket;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.ChainModePacket;
import org.xiyu.yee.onekeyminer.network.ChainPositionsPacket;
import org.xiyu.yee.onekeyminer.network.ConfigSyncPacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;

@EventBusSubscriber(modid="onekeyminer", bus=EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    public static final ResourceLocation CHAIN_MODE_ID = ResourceLocation.parse((String)"onekeyminer:chain_mode");
    public static final ResourceLocation BLOCKS_MINED_ID = ResourceLocation.parse((String)"onekeyminer:blocks_mined");
    public static final ResourceLocation CHAIN_ACTION_ID = ResourceLocation.parse((String)"onekeyminer:chain_action");
    public static final ResourceLocation CONFIG_SYNC_ID = ResourceLocation.parse((String)"onekeyminer:config_sync");
    public static final ResourceLocation CHAIN_POSITIONS_ID = ResourceLocation.parse((String)"onekeyminer:chain_positions");
    public static final CustomPacketPayload.Type<ChainModePacket> CHAIN_MODE_TYPE = new CustomPacketPayload.Type(CHAIN_MODE_ID);
    public static final CustomPacketPayload.Type<BlocksMinedPacket> BLOCKS_MINED_TYPE = new CustomPacketPayload.Type(BLOCKS_MINED_ID);
    public static final CustomPacketPayload.Type<ChainActionPacket> CHAIN_ACTION_TYPE = new CustomPacketPayload.Type(CHAIN_ACTION_ID);
    public static final CustomPacketPayload.Type<ConfigSyncPacket> CONFIG_SYNC_TYPE = new CustomPacketPayload.Type(CONFIG_SYNC_ID);
    public static final CustomPacketPayload.Type<ChainPositionsPacket> CHAIN_POSITIONS_TYPE = new CustomPacketPayload.Type(CHAIN_POSITIONS_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChainModePacket> CHAIN_MODE_CODEC = StreamCodec.of((buf, packet) -> packet.write((FriendlyByteBuf)buf), ChainModePacket::fromNetwork);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlocksMinedPacket> BLOCKS_MINED_CODEC = StreamCodec.of((buf, packet) -> packet.write((FriendlyByteBuf)buf), BlocksMinedPacket::fromNetwork);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChainActionPacket> CHAIN_ACTION_CODEC = StreamCodec.of((buf, packet) -> packet.write((FriendlyByteBuf)buf), ChainActionPacket::fromNetwork);
    public static final StreamCodec<RegistryFriendlyByteBuf, ConfigSyncPacket> CONFIG_SYNC_CODEC = StreamCodec.of((buf, packet) -> packet.write((FriendlyByteBuf)buf), ConfigSyncPacket::fromNetwork);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChainPositionsPacket> CHAIN_POSITIONS_CODEC = StreamCodec.of((buf, packet) -> packet.write((FriendlyByteBuf)buf), ChainPositionsPacket::fromNetwork);

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("onekeyminer").versioned("1.0.0");
        registrar.playBidirectional(CHAIN_MODE_TYPE, CHAIN_MODE_CODEC, (packet, context) -> {
            if (context.flow().isServerbound()) {
                ChainModePacket.handleOnServer(packet, context);
            } else {
                ChainModePacket.handleOnClient(packet, context);
            }
        });
        registrar.playToClient(BLOCKS_MINED_TYPE, BLOCKS_MINED_CODEC, BlocksMinedPacket::handleOnClient);
        registrar.playToClient(CHAIN_ACTION_TYPE, CHAIN_ACTION_CODEC, ChainActionPacket::handleOnClient);
        registrar.playToClient(CONFIG_SYNC_TYPE, CONFIG_SYNC_CODEC, ConfigSyncPacket::handleOnClient);
        registrar.playToClient(CHAIN_POSITIONS_TYPE, CHAIN_POSITIONS_CODEC, ChainPositionsPacket::handleOnClient);
    }

    public static void sendToPlayer(IOneKeyPacket packet, ServerPlayer player) {
        try {
            if (player != null && player.connection != null) {
                if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u5411\u73a9\u5bb6 {} \u53d1\u9001\u6570\u636e\u5305: {}", (Object)player.getScoreboardName(), (Object)packet.getClass().getSimpleName());
                }
                player.connection.send((CustomPacketPayload)packet);
            } else if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.warn("\u65e0\u6cd5\u53d1\u9001\u6570\u636e\u5305: \u73a9\u5bb6\u6216\u8fde\u63a5\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u53d1\u9001\u6570\u636e\u5305\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void sendToServer(IOneKeyPacket packet) {
        Minecraft.getInstance().getConnection().send((CustomPacketPayload)packet);
    }
}

