/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OKMConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class DirectionalExcavationUtils {
    public static void excavateInDirection(Level world, ServerPlayer player, BlockState targetBlock) {
        boolean shouldDamage;
        ItemStack mainHandItem = player.m_21205_();
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)targetBlock, (Player)player)) {
            return;
        }
        Vec3 lookVec = player.m_20154_();
        int dirX = lookVec.f_82479_ > 0.0 ? 1 : -1;
        int dirZ = lookVec.f_82481_ > 0.0 ? 1 : -1;
        ArrayList lootDrops = new ArrayList();
        int totalExpDrop = 0;
        LegacyRandomSource random = (LegacyRandomSource)world.m_213780_();
        int length = (Integer)OKMConfig.max_range.get();
        int height = 2;
        for (int i = 0; i < length; ++i) {
            BlockPos pos = player.m_20183_().m_7918_(dirX, 0, dirZ).m_7918_(0, height / 2, 0).m_7918_(i * dirX, 0, i * dirZ);
            BlockState blockState = world.m_8055_(pos);
            if (!blockState.m_60713_(targetBlock.m_60734_())) continue;
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            Block block = blockState.m_60734_();
            BlockEntity blockEntity = world.m_7702_(pos);
            int silkTouchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)mainHandItem);
            List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)blockEntity);
            lootDrops.addAll(drops);
            int expToDrop = block.getExpDrop(blockState, (LevelReader)world, (RandomSource)random, pos, fortuneLevel, silkTouchLevel);
            totalExpDrop += expToDrop;
        }
        double dropX = player.m_20185_();
        double dropY = player.m_20188_() - (double)player.m_20192_() - 0.5;
        double dropZ = player.m_20189_();
        for (ItemStack drop : lootDrops) {
            ItemEntity itemEntity = new ItemEntity(world, dropX, dropY, dropZ, drop);
            world.m_7967_((Entity)itemEntity);
        }
        if (totalExpDrop > 0) {
            world.m_7967_((Entity)new ExperienceOrb(world, dropX, dropY, dropZ, totalExpDrop));
        }
        mainHandItem = player.m_21205_();
        if (((Boolean)OKMConfig.toolProtectionMode.get()).booleanValue() && !player.m_7500_() && mainHandItem.m_41763_()) {
            double threshold = (Double)OKMConfig.toolDurabilityThreshold.get();
            int maxDamage = mainHandItem.m_41776_();
            int damage = mainHandItem.m_41773_();
            double d = maxDamage - damage;
            double d2 = threshold <= 1.0 ? (double)maxDamage * threshold : threshold;
            if (d < d2) {
                player.m_213846_((Component)Component.m_237115_((String)"message.onekeyminer.low_durability"));
                return;
            }
        }
        if (!player.m_7500_() && mainHandItem.m_41763_() && (shouldDamage = true)) {
            mainHandItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        }
    }
}

