/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.DirectionalExcavationUtils;
import cn.onekeyminer.ExcavatePacket;
import cn.onekeyminer.OKMConfig;
import cn.onekeyminer.OKMUtils;
import cn.onekeyminer.OKM_Chain_farming;
import cn.onekeyminer.PlayerBreakEventUtils;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="onekeyminer")
public class OneKeyMiner {
    public static final SimpleChannel NETWORK_CHANNEL;
    public static final OKMConfig okmconfig;
    static final ForgeConfigSpec configSpec;
    private static final Set<ServerPlayer> playerSet;
    private static final String VERSION = "1";
    private static final String CHANNEL_NAME = "onekeyminer_network";
    static List<String> seedList;
    private static int nextNetworkId;
    public static final String UI = "UI";

    public OneKeyMiner() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configSpec);
        modEventBus.register(ForgeConfig.class);
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        System.out.println(Item.BY_BLOCK);
    }

    public static int getNextNetworkId() {
        return nextNetworkId++;
    }

    public static void keyPressed(ServerPlayer player, boolean isPressed, boolean ignoredIsEmptyHanded, boolean b) {
        BlockPos playerPos = player.blockPosition();
        BlockState blockState = player.level().getBlockState(playerPos);
        ItemStack mainHandItem = player.getMainHandItem();
        if (isPressed) {
            if (mainHandItem.onBlockStartBreak(playerPos, (Player)player)) {
                switch ((Integer)OKMConfig.excavationMode.get()) {
                    case 1: {
                        OKMUtils.chainMine((ServerLevel)player.level(), player, playerPos, blockState);
                    }
                    case 2: {
                        DirectionalExcavationUtils.excavateInDirection(player.level(), player, blockState);
                    }
                    case 3: {
                        PlayerBreakEventUtils.excavateSphere(player.level(), player, playerPos, blockState);
                    }
                }
            } else if (ignoredIsEmptyHanded) {
                playerSet.add(player);
            }
        } else {
            playerSet.remove(player);
        }
        OKM_Chain_farming.planting(isPressed);
    }

    static boolean isSeed(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return false;
        }
        ResourceLocation itemRegName = ForgeRegistries.ITEMS.getKey((Object)itemStack.getItem());
        return itemRegName != null && seedList.contains(itemRegName.toString());
    }

    static {
        playerSet = new HashSet<ServerPlayer>();
        nextNetworkId = 0;
        NETWORK_CHANNEL = ChannelBuilder.named((ResourceLocation)ResourceLocation.tryBuild((String)"onekeyminer", (String)CHANNEL_NAME)).networkProtocolVersion(1).optional().simpleChannel().messageBuilder(ExcavatePacket.class).decoder(ExcavatePacket::decode).encoder(ExcavatePacket::encode).consumerNetworkThread(ExcavatePacket::handle).add();
        Pair specPair = new ForgeConfigSpec.Builder().configure(OKMConfig::new);
        configSpec = (ForgeConfigSpec)specPair.getRight();
        okmconfig = (OKMConfig)specPair.getLeft();
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class KeyInputHandler {
        private static boolean isKeyPressed = false;

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft != null && minecraft.player != null) {
                boolean is_empty_handed;
                LocalPlayer player = minecraft.player;
                ItemStack mainHandItem = player.getMainHandItem();
                ItemStack offHandItem = player.getOffhandItem();
                boolean hasSeed = KeyInputHandler.isSeed(mainHandItem);
                boolean bl = is_empty_handed = mainHandItem.isEmpty() && offHandItem.isEmpty();
                if (ClientEventHandler.KEY_01.isDown()) {
                    if (!isKeyPressed) {
                        isKeyPressed = true;
                        KeyInputHandler.sendPacket(true, !is_empty_handed, hasSeed, player);
                    }
                } else if (isKeyPressed) {
                    isKeyPressed = false;
                    KeyInputHandler.sendDefaultPacket(player);
                }
            }
        }

        private static void sendPacket(boolean start, boolean hasItem, boolean hasSeed, LocalPlayer player) {
            NETWORK_CHANNEL.send((Object)new ExcavatePacket(start, hasItem, hasSeed), player.connection.getConnection());
        }

        private static void sendDefaultPacket(LocalPlayer player) {
            NETWORK_CHANNEL.send((Object)new ExcavatePacket(false, false, false), player.connection.getConnection());
        }

        private static boolean isSeed(ItemStack itemStack) {
            if (itemStack == null || itemStack.isEmpty()) {
                return false;
            }
            ResourceLocation itemRegName = ForgeRegistries.ITEMS.getKey((Object)itemStack.getItem());
            return itemRegName != null && ((List)OKMConfig.seedItems.get()).contains(itemRegName.toString());
        }

        @SubscribeEvent
        public void onBlockBreak(BlockEvent.BreakEvent event) {
            ServerPlayer player;
            if (!event.getLevel().isClientSide() && playerSet.contains(player = (ServerPlayer)event.getPlayer())) {
                switch ((Integer)OKMConfig.excavationMode.get()) {
                    case 1: {
                        OKMUtils.chainMine((ServerLevel)player.level(), player, event.getPos(), event.getState());
                    }
                    case 2: {
                        DirectionalExcavationUtils.excavateInDirection(event.getPlayer().level(), player, event.getState());
                    }
                    case 3: {
                        PlayerBreakEventUtils.excavateSphere(event.getPlayer().level(), player, event.getPos(), event.getState());
                    }
                }
                playerSet.remove(player);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLoadComplete(FMLLoadCompleteEvent event) {
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onServerStarting(PlayerInteractEvent.RightClickBlock event) {
            Player player;
            ItemStack mainHandItem;
            boolean hasSeed;
            if (!event.isCanceled() && (hasSeed = OneKeyMiner.isSeed(mainHandItem = (player = event.getEntity()).getMainHandItem())) && OKM_Chain_farming.isPressed) {
                OKM_Chain_farming.planting0(player, player.level(), event.getPos(), player.getMainHandItem());
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEventHandler {
        public static final KeyMapping KEY_01 = new KeyMapping("key.onekeyminer.key1_unique_name", InputConstants.Type.KEYSYM, 96, "key.categories.gameplay");

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(KEY_01);
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonProxy {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            if (configSpec.isLoaded()) {
                seedList = (List)OKMConfig.seedItems.get();
            }
        }
    }
}

