/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.BlockDetectionMode;
import cn.onekeyminer.Direction26;
import cn.onekeyminer.OKMConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class OKMUtils {
    public static void chainMine(ServerLevel world, ServerPlayer player, BlockPos pos, BlockState state) {
        int count = OKMUtils.startChainMine(world, player, pos, state);
        int statValue = player.m_8951_().m_13015_(Stats.f_12949_.m_12902_((Object)state.m_60734_()));
        player.m_8951_().m_6085_((Player)player, Stats.f_12949_.m_12902_((Object)state.m_60734_()), statValue + count);
        player.m_213846_((Component)Component.m_237113_((String)("\u8fde\u9501\u6316\u6398\u4e86" + count + "\u4e2a\u65b9\u5757")));
    }

    public static int startChainMine(ServerLevel world, ServerPlayer player, BlockPos pos, BlockState state) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int expTotal = 0;
        ItemStack mainHandItem = player.m_21205_();
        int maxCount = Math.min(Math.max(mainHandItem.m_41776_() - mainHandItem.m_41773_() - 5, 1), (Integer)OKMConfig.max_count.get());
        List blocks = OKMUtils.getConnectedBlocksByRadioLevelOrder((Level)world, pos, (Integer)OKMConfig.max_range.get(), blockState -> blockState.m_60713_(state.m_60734_()) && ForgeHooks.isCorrectToolForDrops((BlockState)blockState, (Player)player)).stream().limit(maxCount).collect(Collectors.toList());
        int blocksMined = 0;
        for (BlockPos blockPos : blocks) {
            if (!player.m_7500_() && mainHandItem.m_41763_()) {
                int maxDamage = mainHandItem.m_41776_();
                int damage = mainHandItem.m_41773_();
                if (((Boolean)OKMConfig.toolProtectionMode.get()).booleanValue()) {
                    double d = maxDamage - damage;
                    double d2 = (Double)OKMConfig.toolDurabilityThreshold.get() <= 1.0 ? (double)maxDamage * (Double)OKMConfig.toolDurabilityThreshold.get() : (Double)OKMConfig.toolDurabilityThreshold.get();
                    if (d < d2) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.onekeyminer.low_durability"));
                        return blocksMined;
                    }
                }
                mainHandItem.m_41721_(damage + 1);
                if (mainHandItem.m_41773_() >= maxDamage) {
                    mainHandItem.m_41721_(0);
                    player.m_21190_(player.m_7655_());
                    return blocksMined;
                }
            }
            BlockState blockState2 = world.m_8055_(blockPos);
            List singleBlockDrops = blockState2.m_287290_(new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)world.m_7702_(blockPos)));
            for (ItemStack singleBlockDrop : singleBlockDrops) {
                OKMUtils.addItemStack(drops, singleBlockDrop);
            }
            expTotal += blockState2.getExpDrop((LevelReader)world, world.f_46441_, blockPos, player.m_21205_().getEnchantmentLevel(Enchantments.f_44985_), player.m_21205_().getEnchantmentLevel(Enchantments.f_44987_));
            world.m_7471_(blockPos, false);
            ++blocksMined;
        }
        drops.forEach(stack -> world.m_7967_((Entity)new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack)));
        if (expTotal > 0) {
            world.m_7967_((Entity)new ExperienceOrb((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), expTotal));
        }
        return blocksMined;
    }

    public static LinkedHashSet<BlockPos> getConnectedBlocksByRadioLevelOrder(Level level, BlockPos center, int radius, Predicate<BlockState> blockStatePredicate) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayList<BlockPos> visitedPositions = new ArrayList<BlockPos>();
        queue.add(center);
        visited.add(center);
        visitedPositions.add(center);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            List<BlockPos> neighbors = OKMUtils.getBlockPoses(current, level, blockStatePredicate);
            for (BlockPos neighbor : neighbors) {
                if (visited.contains(neighbor) || !OKMUtils.isWithinRadius(neighbor, center, radius)) continue;
                queue.add(neighbor);
                visited.add(neighbor);
                visitedPositions.add(neighbor);
            }
        }
        return new LinkedHashSet<BlockPos>(visitedPositions);
    }

    private static List<BlockPos> getBlockPoses(BlockPos center, Level level, Predicate<BlockState> blockStatePredicate) {
        return switch ((BlockDetectionMode)((Object)OKMConfig.block_detection_mode.get())) {
            case BlockDetectionMode.DIRECTIONS_8 -> OKMUtils.get2DAroundBlockPoses(center, level, blockStatePredicate);
            case BlockDetectionMode.DIRECTIONS_26 -> OKMUtils.get3DAroundBlockPoses(center, level, blockStatePredicate);
            default -> OKMUtils.getNeighborBlockPoses(center, level, blockStatePredicate);
        };
    }

    private static List<BlockPos> getNeighborBlockPoses(BlockPos pos, Level level, Predicate<BlockState> blockStatePredicate) {
        return Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0)).filter(blockPos -> blockStatePredicate.test(level.m_8055_(blockPos))).toList();
    }

    private static List<BlockPos> get2DAroundBlockPoses(BlockPos pos, Level level, Predicate<BlockState> blockStatePredicate) {
        return Arrays.stream(Direction8.values()).map(direction8 -> {
            direction8.m_122593_().forEach(arg_0 -> ((BlockPos)pos).m_121945_(arg_0));
            return pos;
        }).filter(blockPos -> blockStatePredicate.test(level.m_8055_(blockPos))).toList();
    }

    private static List<BlockPos> get3DAroundBlockPoses(BlockPos pos, Level level, Predicate<BlockState> blockStatePredicate) {
        return Arrays.stream(Direction26.values()).map(direction26 -> pos.m_121955_(direction26.offset())).filter(blockPos -> blockStatePredicate.test(level.m_8055_(blockPos))).toList();
    }

    private static boolean isWithinRadius(BlockPos pos, BlockPos center, int radius) {
        return pos.m_123331_((Vec3i)center) <= (double)(radius * radius);
    }

    private static void addItemStack(ArrayList<ItemStack> drops, ItemStack stack) {
        for (ItemStack itemStack : drops) {
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack)) continue;
            itemStack.m_41769_(stack.m_41613_());
            return;
        }
        drops.add(stack);
    }
}

