/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OKMConfig;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.common.ForgeHooks;

public class OKMUtils_Number_chains {
    public static void excavateSphere(Level world, ServerPlayer player, BlockPos centerPos, BlockState targetBlock) {
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)targetBlock, (Player)player)) {
            return;
        }
        LegacyRandomSource random = (LegacyRandomSource)world.m_213780_();
        ItemStack mainHandItem = player.m_21205_();
        int maxBlocks = (Integer)OKMConfig.max_count.get();
        double dropX = player.m_20185_();
        double dropY = player.m_20188_() - (double)player.m_20192_() - 0.5;
        double dropZ = player.m_20189_();
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>(Collections.singletonList(centerPos));
        int count = 0;
        player.m_213846_((Component)Component.m_237113_((String)"\u5f00\u59cb\u8fde\u9501\u6316\u6398..."));
        while (!queue.isEmpty() && count < maxBlocks) {
            BlockPos pos = (BlockPos)queue.poll();
            if (processed.contains(pos)) continue;
            processed.add(pos);
            BlockState blockState = world.m_8055_(pos);
            if (!blockState.m_60713_(targetBlock.m_60734_())) continue;
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            Block block = blockState.m_60734_();
            BlockEntity blockEntity = world.m_7702_(pos);
            int silkTouchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)mainHandItem);
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)mainHandItem);
            List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)blockEntity);
            for (ItemStack drop : drops) {
                world.m_7967_((Entity)new ItemEntity(world, dropX, dropY, dropZ, drop));
            }
            int expToDrop = block.getExpDrop(blockState, (LevelReader)world, (RandomSource)random, pos, fortuneLevel, silkTouchLevel);
            if (expToDrop > 0) {
                world.m_7967_((Entity)new ExperienceOrb(world, dropX, dropY, dropZ, expToDrop));
            }
            for (Direction direction : Direction.values()) {
                BlockPos neighbor = pos.m_121945_(direction);
                if (processed.contains(neighbor) || !world.m_8055_(neighbor).m_60713_(targetBlock.m_60734_())) continue;
                queue.add(neighbor);
            }
            OKMUtils_Number_chains.damageTool((Player)player, mainHandItem);
            if (!player.f_8941_.m_9295_() && ((Boolean)OKMConfig.Saturationdeduction.get()).booleanValue()) {
                OKMUtils_Number_chains.decreaseHunger(player, 0.005);
            }
            ++count;
        }
        player.m_213846_((Component)Component.m_237110_((String)"message.onekeyminer.Number_of_interlocking_blocks", (Object[])new Object[]{count}));
        System.out.println("\u8fde\u9501\u6316\u6398\u5faa\u73af\u6267\u884c\u6b21\u6570\uff1a" + count);
    }

    private static void damageTool(Player player, ItemStack itemStack) {
        if (((Boolean)OKMConfig.toolProtectionMode.get()).booleanValue() && !player.m_7500_() && itemStack.m_41763_()) {
            boolean shouldDamage;
            double threshold = (Double)OKMConfig.toolDurabilityThreshold.get();
            int maxDamage = itemStack.m_41776_();
            int damage = itemStack.m_41773_();
            double d = maxDamage - damage;
            double d2 = threshold <= 1.0 ? (double)maxDamage * threshold : threshold;
            if (d < d2) {
                player.m_213846_((Component)Component.m_237115_((String)"message.onekeyminer.low_durability"));
                return;
            }
            if (!player.m_7500_() && itemStack.m_41763_() && (shouldDamage = true)) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            }
        }
    }

    private static void decreaseHunger(ServerPlayer player, double amount) {
        FoodData foodData = player.m_36324_();
        float foodSaturationLevel = foodData.m_38722_();
        int foodLevel = foodData.m_38702_();
        if ((double)foodLevel > (Double)OKMConfig.SaturationdeductionThreshold.get()) {
            if ((double)foodSaturationLevel >= amount) {
                foodData.m_38717_((float)((double)foodSaturationLevel - amount));
            } else {
                foodData.m_38717_(0.0f);
                int newFoodLevel = (int)Math.max((double)foodLevel - (amount -= (double)foodSaturationLevel), 0.0);
                foodData.m_38705_(newFoodLevel);
            }
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"message.onekeyminer.low_foodlevel"));
            throw new RuntimeException("Hunger level too low to continue chain mining.");
        }
    }
}

