/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OKMConfig;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.common.ForgeHooks;

public class OKMUtils_Number_chains {
    public static void excavateSphere(Level world, ServerPlayer player, BlockPos centerPos, BlockState targetBlock) {
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)targetBlock, (Player)player)) {
            return;
        }
        LegacyRandomSource random = (LegacyRandomSource)world.getRandom();
        ItemStack mainHandItem = player.getMainHandItem();
        int maxBlocks = (Integer)OKMConfig.max_count.get();
        double dropX = player.getX();
        double dropY = player.getEyeY() - (double)player.getEyeHeight() - 0.5;
        double dropZ = player.getZ();
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>(Collections.singletonList(centerPos));
        int count = 0;
        player.sendSystemMessage((Component)Component.literal((String)"\u5f00\u59cb\u8fde\u9501\u6316\u6398..."));
        while (!queue.isEmpty() && count < maxBlocks) {
            BlockPos pos = (BlockPos)queue.poll();
            if (processed.contains(pos)) continue;
            processed.add(pos);
            BlockState blockState = world.getBlockState(pos);
            if (!blockState.is(targetBlock.getBlock())) continue;
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            Block block = blockState.getBlock();
            BlockEntity blockEntity = world.getBlockEntity(pos);
            int silkTouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.SILK_TOUCH, (ItemStack)mainHandItem);
            int fortuneLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.BLOCK_FORTUNE, (ItemStack)mainHandItem);
            List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)blockEntity);
            for (ItemStack drop : drops) {
                world.addFreshEntity((Entity)new ItemEntity(world, dropX, dropY, dropZ, drop));
            }
            int expToDrop = block.getExpDrop(blockState, (LevelReader)world, (RandomSource)random, pos, fortuneLevel, silkTouchLevel);
            if (expToDrop > 0) {
                world.addFreshEntity((Entity)new ExperienceOrb(world, dropX, dropY, dropZ, expToDrop));
            }
            for (Direction direction : Direction.values()) {
                BlockPos neighbor = pos.relative(direction);
                if (processed.contains(neighbor) || !world.getBlockState(neighbor).is(targetBlock.getBlock())) continue;
                queue.add(neighbor);
            }
            OKMUtils_Number_chains.damageTool((Player)player, mainHandItem);
            if (!player.gameMode.isCreative() && ((Boolean)OKMConfig.Saturationdeduction.get()).booleanValue()) {
                OKMUtils_Number_chains.decreaseHunger(player, 0.005);
            }
            ++count;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.Number_of_interlocking_blocks", (Object[])new Object[]{count}));
        System.out.println("\u8fde\u9501\u6316\u6398\u5faa\u73af\u6267\u884c\u6b21\u6570\uff1a" + count);
    }

    private static void damageTool(Player player, ItemStack itemStack) {
        if (((Boolean)OKMConfig.toolProtectionMode.get()).booleanValue() && !player.isCreative() && itemStack.isDamageableItem()) {
            boolean shouldDamage;
            double threshold = (Double)OKMConfig.toolDurabilityThreshold.get();
            int maxDamage = itemStack.getMaxDamage();
            int damage = itemStack.getDamageValue();
            double d = maxDamage - damage;
            double d2 = threshold <= 1.0 ? (double)maxDamage * threshold : threshold;
            if (d < d2) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.low_durability"));
                return;
            }
            if (player.isCreative() || !itemStack.isDamageableItem() || (shouldDamage = true)) {
                // empty if block
            }
        }
    }

    private static void decreaseHunger(ServerPlayer player, double amount) {
        FoodData foodData = player.getFoodData();
        float foodSaturationLevel = foodData.getSaturationLevel();
        int foodLevel = foodData.getFoodLevel();
        if ((double)foodLevel > (Double)OKMConfig.SaturationdeductionThreshold.get()) {
            if ((double)foodSaturationLevel >= amount) {
                foodData.setSaturation((float)((double)foodSaturationLevel - amount));
            } else {
                foodData.setSaturation(0.0f);
                int newFoodLevel = (int)Math.max((double)foodLevel - (amount -= (double)foodSaturationLevel), 0.0);
                foodData.setFoodLevel(newFoodLevel);
            }
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.low_foodlevel"));
            throw new RuntimeException("Hunger level too low to continue chain mining.");
        }
    }
}

