/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.capability;

import cn.onekeyminer.onekeyminer.config.ClientConfig;
import cn.onekeyminer.onekeyminer.network.ChainModePacket;
import cn.onekeyminer.onekeyminer.network.NetworkHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="onekeyminer")
public class ChainModeCapability {
    public static final Capability<IChainMode> CHAIN_MODE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChainMode>(){});
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init(IEventBus modEventBus) {
        MinecraftForge.EVENT_BUS.addListener(ChainModeCapability::onPlayerClone);
        MinecraftForge.EVENT_BUS.addGenericListener(Player.class, ChainModeCapability::attachCapabilities);
    }

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
        event.register(IChainMode.class);
        LOGGER.debug("\u6ce8\u518c\u94fe\u5f0f\u6316\u6398\u80fd\u529b");
    }

    public static boolean isChainModeActive(Player player) {
        boolean result = player.getCapability(CHAIN_MODE_CAPABILITY).map(IChainMode::isActive).orElse(false);
        if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            LOGGER.debug("\u68c0\u67e5\u73a9\u5bb6 {} \u7684\u94fe\u5f0f\u6316\u6398\u6a21\u5f0f: {}, \u80fd\u529b\u662f\u5426\u5b58\u5728: {}", (Object)player.getName().getString(), (Object)result, (Object)player.getCapability(CHAIN_MODE_CAPABILITY).isPresent());
        }
        return result;
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        if (!((Entity)event.getObject()).getCapability(CHAIN_MODE_CAPABILITY).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"onekeyminer", (String)"chain_mode"), (ICapabilityProvider)new ChainModeProvider());
            LOGGER.debug("\u4e3a\u73a9\u5bb6\u9644\u52a0\u94fe\u5f0f\u6316\u6398\u80fd\u529b");
        }
    }

    public static void setChainMode(ServerPlayer player, boolean active) {
        player.getCapability(CHAIN_MODE_CAPABILITY).ifPresent(chainMode -> {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                LOGGER.debug("\u8bbe\u7f6e\u73a9\u5bb6 {} \u7684\u94fe\u5f0f\u6316\u6398\u6a21\u5f0f\u4e3a: {}", (Object)player.getName().getString(), (Object)active);
            }
            chainMode.setActive(active);
            NetworkHandler.sendToPlayer(new ChainModePacket(active), player);
        });
    }

    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (event.isWasDeath()) {
            original.getCapability(CHAIN_MODE_CAPABILITY).ifPresent(origCap -> clone.getCapability(CHAIN_MODE_CAPABILITY).ifPresent(cloneCap -> cloneCap.setActive(origCap.isActive())));
        }
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<Player> event) {
        if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            LOGGER.debug("\u5728\u73a9\u5bb6 {} \u8eab\u4e0a\u9644\u52a0\u94fe\u5f0f\u6316\u6398\u80fd\u529b", (Object)((Player)event.getObject()).getName().getString());
        }
        event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"onekeyminer", (String)"chain_mode"), (ICapabilityProvider)new ChainModeProvider());
        event.addListener(() -> {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                LOGGER.debug("\u73a9\u5bb6 {} \u7684\u94fe\u5f0f\u6316\u6398\u80fd\u529b\u5df2\u5931\u6548", (Object)((Player)event.getObject()).getName().getString());
            }
        });
    }

    public static interface IChainMode {
        public boolean isActive();

        public void setActive(boolean var1);
    }

    public static class ChainModeProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final ChainMode instance = new ChainMode();
        private final LazyOptional<IChainMode> lazyOptional = LazyOptional.of(() -> this.instance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == CHAIN_MODE_CAPABILITY ? this.lazyOptional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("active", this.instance.isActive());
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                LOGGER.debug("\u5e8f\u5217\u5316\u73a9\u5bb6\u7684\u94fe\u5f0f\u6316\u6398\u6a21\u5f0f: {}", (Object)this.instance.isActive());
            }
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            boolean active = tag.getBoolean("active");
            this.instance.setActive(active);
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                LOGGER.debug("\u53cd\u5e8f\u5217\u5316\u73a9\u5bb6\u7684\u94fe\u5f0f\u6316\u6398\u6a21\u5f0f: {}", (Object)active);
            }
        }

        public CompoundTag serializeNBT() {
            return this.serializeNBT(null);
        }

        public void deserializeNBT(CompoundTag tag) {
            this.deserializeNBT(null, tag);
        }
    }

    public static class ChainMode
    implements IChainMode {
        private boolean active = false;

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public void setActive(boolean active) {
            this.active = active;
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer")
    public static class PlayerLoginHandler {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.getCapability(CHAIN_MODE_CAPABILITY).ifPresent(chainMode -> {
                    if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                        LOGGER.debug("\u5728\u73a9\u5bb6 {} \u767b\u5f55\u65f6\u540c\u6b65\u94fe\u5f0f\u6316\u6398\u6a21\u5f0f: {}", (Object)serverPlayer.getName().getString(), (Object)chainMode.isActive());
                    }
                    NetworkHandler.sendToPlayer(new ChainModePacket(chainMode.isActive()), serverPlayer);
                });
            }
        }
    }
}

