/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.chain;

import cn.onekeyminer.onekeyminer.Onekeyminer;
import cn.onekeyminer.onekeyminer.capability.ChainModeCapability;
import cn.onekeyminer.onekeyminer.config.ClientConfig;
import cn.onekeyminer.onekeyminer.config.CommonConfig;
import cn.onekeyminer.onekeyminer.config.ServerConfig;
import cn.onekeyminer.onekeyminer.network.ChainActionPacket;
import cn.onekeyminer.onekeyminer.network.NetworkHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ChainHandler {
    private static final Set<BlockPos> CURRENTLY_MINING = new HashSet<BlockPos>();

    public static boolean tryChainMine(ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        int blocksMined;
        CURRENTLY_MINING.clear();
        if ((player == null || pos == null || state == null || tool == null) && ((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u8fde\u9501\u6316\u6398\u53c2\u6570\u65e0\u6548");
            return false;
        }
        if (!ChainHandler.validateChainMiningConditions(player, pos, state, tool)) {
            return false;
        }
        String blockId = state.getBlock().getDescriptionId();
        String blockName = state.getBlock().getName().getString();
        if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5f00\u59cb\u8fde\u9501\u6316\u6398: {} (\u5185\u90e8ID: {})", (Object)blockName, (Object)blockId);
        }
        if ((blocksMined = ChainHandler.performChainMining(player, pos, state, tool)) > 0) {
            ChainHandler.sendFeedback(player, blocksMined);
        }
        return blocksMined > 0;
    }

    private static boolean validateChainMiningConditions(ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        if (!ChainModeCapability.isChainModeActive((Player)player)) {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u8fde\u9501\u6a21\u5f0f\u672a\u542f\u7528");
            }
            return false;
        }
        if (state.isAir()) {
            return false;
        }
        if (((Boolean)CommonConfig.REQUIRE_SNEAKING.get()).booleanValue() && !player.isShiftKeyDown()) {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u9700\u8981\u4e0b\u8e72\u4f46\u73a9\u5bb6\u672a\u4e0b\u8e72");
            }
            return false;
        }
        if (player.isCreative() && !((Boolean)CommonConfig.ENABLE_IN_CREATIVE.get()).booleanValue()) {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u672a\u542f\u7528");
            }
            return false;
        }
        if (!player.isCreative() && (double)player.getFoodData().getFoodLevel() < (Double)ServerConfig.HUNGER_THRESHOLD.get()) {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u73a9\u5bb6\u9965\u997f\u5ea6\u4e0d\u8db3: {} < {}", (Object)player.getFoodData().getFoodLevel(), ServerConfig.HUNGER_THRESHOLD.get());
            }
            return false;
        }
        String blockId = state.getBlock().getDescriptionId();
        String blockName = state.getBlock().getName().getString();
        if (!CommonConfig.isBlockMineable(blockId)) {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u65b9\u5757\u5728\u4e0d\u53ef\u6316\u6398\u5217\u8868\u4e2d: {} (\u5185\u90e8ID: {})", (Object)blockName, (Object)blockId);
            }
            return false;
        }
        if (!((Boolean)CommonConfig.IGNORE_TOOL_COMPATIBILITY.get()).booleanValue() && !player.hasCorrectToolForDrops(state)) {
            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u5de5\u5177\u4e0d\u517c\u5bb9: {}", (Object)tool.getItem().getDescriptionId());
            }
            return false;
        }
        if (!player.isCreative() && tool.isDamageableItem()) {
            Double durabilityProtection = (Double)ServerConfig.TOOL_DURABILITY_THRESHOLD.get();
            if ((double)tool.getDamageValue() >= (double)tool.getMaxDamage() - durabilityProtection) {
                if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u5de5\u5177\u8010\u4e45\u5ea6\u4e0d\u8db3\u8fdb\u884c\u8fde\u9501\u6316\u6398");
                }
                return false;
            }
        }
        return true;
    }

    private static int performChainMining(ServerPlayer player, BlockPos startPos, BlockState startState, ItemStack tool) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return 0;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int maxBlocks = player.isCreative() ? (Integer)CommonConfig.MAX_BLOCKS_IN_CHAIN_CREATIVE.get() : (Integer)CommonConfig.MAX_BLOCKS_IN_CHAIN.get();
        int maxDepth = (Integer)CommonConfig.MAX_CHAIN_DEPTH.get();
        boolean diagonal = (Boolean)CommonConfig.ENABLE_DIAGONAL_CHAINING.get();
        boolean matchFullState = (Boolean)CommonConfig.MATCH_BLOCK_STATE.get();
        boolean teleportDrops = (Boolean)CommonConfig.TELEPORT_DROPS_TO_PLAYER.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        HashSet<BlockPos> minedPositions = new HashSet<BlockPos>();
        toMine.add(startPos);
        int blocksMined = 0;
        while (!toMine.isEmpty() && blocksMined < maxBlocks) {
            boolean blockDestroyed;
            BlockState currentState;
            BlockPos currentPos = (BlockPos)toMine.poll();
            if (minedPositions.contains(currentPos) || Math.abs(currentPos.getY() - startPos.getY()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.getBlockState(currentPos), matchFullState)) continue;
            minedPositions.add(currentPos);
            if (teleportDrops) {
                blockDestroyed = ChainHandler.breakBlockWithTeleport(serverLevel, currentPos, currentState, player, tool);
            } else {
                blockDestroyed = level.destroyBlock(currentPos, true, (Entity)player);
                if (blockDestroyed && !player.isCreative() && tool.isDamageableItem()) {
                    tool.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                    if (tool.isEmpty()) break;
                }
            }
            if (!blockDestroyed) continue;
            ++blocksMined;
            for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                if (minedPositions.contains(neighbor)) continue;
                toMine.add(neighbor);
            }
        }
        return blocksMined;
    }

    private static boolean isBlockMatching(BlockState reference, BlockState target, boolean matchFullState) {
        if (target.isAir()) {
            return false;
        }
        if (matchFullState) {
            return reference.equals(target);
        }
        if (reference.getBlock() == target.getBlock()) {
            if (ChainHandler.hasSpecialMatchingRules(reference.getBlock())) {
                return ChainHandler.matchSpecialBlockProperties(reference, target);
            }
            return true;
        }
        return false;
    }

    private static boolean hasSpecialMatchingRules(Block block) {
        String blockId = block.getDescriptionId();
        return blockId.contains("ore") || blockId.contains("log") || blockId.contains("wood") || blockId.contains("leaves");
    }

    private static boolean matchSpecialBlockProperties(BlockState reference, BlockState target) {
        if (reference.getBlock().getDescriptionId().contains("ore")) {
            return true;
        }
        if (reference.getBlock().getDescriptionId().contains("log") || reference.getBlock().getDescriptionId().contains("wood")) {
            String refType = ChainHandler.extractWoodType(reference.getBlock().getDescriptionId());
            String targetType = ChainHandler.extractWoodType(target.getBlock().getDescriptionId());
            return refType.equals(targetType);
        }
        if (reference.getBlock().getDescriptionId().contains("leaves")) {
            String refType = ChainHandler.extractWoodType(reference.getBlock().getDescriptionId());
            String targetType = ChainHandler.extractWoodType(target.getBlock().getDescriptionId());
            return refType.equals(targetType);
        }
        return true;
    }

    private static String extractWoodType(String blockId) {
        for (String woodType : new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson", "warped", "mangrove", "cherry"}) {
            if (!blockId.contains(woodType)) continue;
            return woodType;
        }
        return blockId;
    }

    private static boolean breakBlockWithTeleport(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, ItemStack tool) {
        if (level == null) {
            return false;
        }
        BlockPos dropPos = player.blockPosition();
        try {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)tool);
            boolean removed = level.removeBlock(pos, false);
            if (!removed) {
                return false;
            }
            for (ItemStack itemStack : drops) {
                if (itemStack.isEmpty()) continue;
                Block.popResource((Level)level, (BlockPos)dropPos, (ItemStack)itemStack);
            }
            state.spawnAfterBreak(level, pos, tool, true);
            level.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative() && tool.isDamageableItem()) {
                tool.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                if (tool.isEmpty()) {
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u4f20\u9001\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(14);
        neighbors.add(pos.above());
        neighbors.add(pos.below());
        neighbors.add(pos.north());
        neighbors.add(pos.south());
        neighbors.add(pos.east());
        neighbors.add(pos.west());
        if (includeDiagonal) {
            neighbors.add(pos.north().east());
            neighbors.add(pos.north().west());
            neighbors.add(pos.south().east());
            neighbors.add(pos.south().west());
            neighbors.add(pos.above().north());
            neighbors.add(pos.above().south());
            neighbors.add(pos.above().east());
            neighbors.add(pos.above().west());
            neighbors.add(pos.below().north());
            neighbors.add(pos.below().south());
            neighbors.add(pos.below().east());
            neighbors.add(pos.below().west());
        }
        return neighbors;
    }

    private static void sendFeedback(ServerPlayer player, int blocksMined) {
        String messageStyle = (String)ClientConfig.MESSAGE_STYLE.get();
        if (((Boolean)ClientConfig.SHOW_BLOCK_COUNT.get()).booleanValue()) {
            if (messageStyle.equals("chat") || messageStyle.equals("both")) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.chain_count", (Object[])new Object[]{blocksMined}));
            }
            if (messageStyle.equals("actionbar") || messageStyle.equals("both")) {
                NetworkHandler.sendToPlayer(new ChainActionPacket("mining", blocksMined), player);
            }
        }
    }
}

