/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.chain;

import cn.onekeyminer.onekeyminer.Onekeyminer;
import cn.onekeyminer.onekeyminer.config.ClientConfig;
import cn.onekeyminer.onekeyminer.config.CommonConfig;
import cn.onekeyminer.onekeyminer.network.ChainActionPacket;
import cn.onekeyminer.onekeyminer.network.NetworkHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class InteractionHandler {
    private static final Set<BlockPos> PROCESSED_POSITIONS = new HashSet<BlockPos>();
    private static final Set<Integer> PROCESSED_ENTITY_IDS = new HashSet<Integer>();

    public static boolean isValidInteractionTool(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof ShearsItem || item instanceof BrushItem;
    }

    @Deprecated
    public static void handleChainInteraction(ServerPlayer player, PlayerInteractEvent.RightClickBlock event) {
        InteractionHandler.tryChainInteraction(player, (ServerLevel)event.getLevel(), event.getPos(), event.getFace(), event.getHitVec().getLocation(), event.getHand());
    }

    public static boolean tryChainInteraction(ServerPlayer player, ServerLevel level, BlockPos pos, Direction side, Vec3 hitVec, InteractionHand hand) {
        PROCESSED_POSITIONS.clear();
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return false;
        }
        BlockState initialState = level.getBlockState(pos);
        if (initialState.isAir()) {
            return false;
        }
        if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u4ea4\u4e92: {}", (Object)initialState.getBlock().getDescriptionId());
        }
        BlockHitResult initialHit = new BlockHitResult(hitVec, side, pos, false);
        int maxBlocks = player.isCreative() ? (Integer)CommonConfig.MAX_BLOCKS_IN_CHAIN_CREATIVE.get() : (Integer)CommonConfig.MAX_BLOCKS_IN_CHAIN.get();
        boolean includeDiagonal = (Boolean)CommonConfig.ENABLE_DIAGONAL_CHAINING.get();
        int processedCount = InteractionHandler.floodFillInteraction(player, level, initialState, initialHit, hand, maxBlocks, (Integer)CommonConfig.MAX_MINING_DEPTH.get(), includeDiagonal);
        if (processedCount > 0) {
            NetworkHandler.sendToPlayer(new ChainActionPacket("interaction", processedCount), player);
            return true;
        }
        return false;
    }

    private static int floodFillInteraction(ServerPlayer player, ServerLevel level, BlockState targetState, BlockHitResult initialHit, InteractionHand hand, int maxBlocks, int maxDepth, boolean includeDiagonal) {
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        queue.add(new BlockSearchNode(initialHit.getBlockPos(), 0));
        int processedCount = 0;
        ItemStack heldItem = player.getItemInHand(hand);
        while (!queue.isEmpty() && processedCount < maxBlocks) {
            BlockState state;
            BlockSearchNode node = (BlockSearchNode)queue.poll();
            BlockPos pos = node.pos;
            if (node.depth > maxDepth || PROCESSED_POSITIONS.contains(pos) || !InteractionHandler.isMatchingBlock(state = level.getBlockState(pos), targetState)) continue;
            if (heldItem.isEmpty() || heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) break;
            PROCESSED_POSITIONS.add(pos);
            BlockHitResult hit = new BlockHitResult(initialHit.getLocation(), initialHit.getDirection(), pos, false);
            UseOnContext context = new UseOnContext((Player)player, hand, hit);
            InteractionResult result = heldItem.useOn(context);
            if (result.consumesAction()) {
                ++processedCount;
                if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u6210\u529f: {}", (Object)pos);
                }
            }
            for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
            }
        }
        Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u65b9\u5757", (Object)processedCount);
        return processedCount;
    }

    private static boolean isMatchingBlock(BlockState state, BlockState target) {
        if (state.isAir() || target.isAir()) {
            return false;
        }
        if (((Boolean)CommonConfig.MATCH_BLOCK_STATE.get()).booleanValue()) {
            return state.equals(target);
        }
        return state.getBlock() == target.getBlock();
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.above());
        neighbors.add(pos.below());
        neighbors.add(pos.north());
        neighbors.add(pos.south());
        neighbors.add(pos.east());
        neighbors.add(pos.west());
        if (includeDiagonal) {
            neighbors.add(pos.north().east());
            neighbors.add(pos.north().west());
            neighbors.add(pos.south().east());
            neighbors.add(pos.south().west());
            neighbors.add(pos.above().north());
            neighbors.add(pos.above().south());
            neighbors.add(pos.above().east());
            neighbors.add(pos.above().west());
            neighbors.add(pos.below().north());
            neighbors.add(pos.below().south());
            neighbors.add(pos.below().east());
            neighbors.add(pos.below().west());
            neighbors.add(pos.above().north().east());
            neighbors.add(pos.above().north().west());
            neighbors.add(pos.above().south().east());
            neighbors.add(pos.above().south().west());
            neighbors.add(pos.below().north().east());
            neighbors.add(pos.below().north().west());
            neighbors.add(pos.below().south().east());
            neighbors.add(pos.below().south().west());
        }
        return neighbors;
    }

    public static boolean tryChainShearing(ServerPlayer player, Sheep targetSheep, InteractionHand hand) {
        PROCESSED_ENTITY_IDS.clear();
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty() || !(heldItem.getItem() instanceof ShearsItem)) {
            return false;
        }
        if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u526a\u7f8a\u6bdb: {}", (Object)targetSheep.getId());
        }
        int maxEntities = player.isCreative() ? (Integer)CommonConfig.MAX_BLOCKS_IN_CHAIN_CREATIVE.get() : (Integer)CommonConfig.MAX_BLOCKS_IN_CHAIN.get();
        double searchRadius = (double)((Integer)CommonConfig.MAX_CHAIN_DEPTH.get()).intValue() * 0.5;
        if (((Boolean)CommonConfig.ENABLE_DIAGONAL_CHAINING.get()).booleanValue()) {
            searchRadius *= 1.5;
        }
        PROCESSED_ENTITY_IDS.add(targetSheep.getId());
        boolean teleportDrops = (Boolean)CommonConfig.TELEPORT_DROPS_TO_PLAYER.get();
        BlockPos playerPos = player.blockPosition();
        ServerLevel level = (ServerLevel)player.level();
        AABB searchBox = new AABB(targetSheep.getX() - searchRadius, targetSheep.getY() - searchRadius, targetSheep.getZ() - searchRadius, targetSheep.getX() + searchRadius, targetSheep.getY() + searchRadius, targetSheep.getZ() + searchRadius);
        List allSheepInArea = level.getEntitiesOfClass(Sheep.class, searchBox, sheep -> sheep.isAlive() && sheep.readyForShearing() && !PROCESSED_ENTITY_IDS.contains(sheep.getId()));
        if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u627e\u5230 {} \u53ea\u53ef\u526a\u7f8a", (Object)(allSheepInArea.size() + 1));
        }
        int shearedCount = 1;
        for (Sheep sheep2 : allSheepInArea) {
            if (shearedCount >= maxEntities) break;
            try {
                if (!sheep2.isShearable(heldItem, player.level(), sheep2.blockPosition()) || !sheep2.readyForShearing()) continue;
                boolean wasShearable = sheep2.readyForShearing();
                int woolColorBefore = sheep2.getColor().getId();
                boolean shearingSuccessful = false;
                if (teleportDrops) {
                    double originalX = sheep2.getX();
                    double originalY = sheep2.getY();
                    double originalZ = sheep2.getZ();
                    try {
                        sheep2.setPos((double)playerPos.getX(), (double)playerPos.getY(), (double)playerPos.getZ());
                        if (sheep2.readyForShearing()) {
                            List items = sheep2.onSheared((Player)player, heldItem, (Level)level, sheep2.blockPosition(), 1);
                            boolean bl = shearingSuccessful = !items.isEmpty();
                            if (shearingSuccessful && !player.getAbilities().instabuild) {
                                heldItem.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                            }
                            items.forEach(itemStack -> {
                                ItemEntity itemEntity = new ItemEntity((Level)level, sheep2.getX(), sheep2.getY(1.0), sheep2.getZ(), itemStack);
                                level.addFreshEntity((Entity)itemEntity);
                            });
                            if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                                Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                            }
                        }
                        sheep2.setPos(originalX, originalY, originalZ);
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u4f20\u9001\u7f8a\u6bdb\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                        sheep2.setPos(originalX, originalY, originalZ);
                    }
                } else if (sheep2.readyForShearing()) {
                    List items = sheep2.onSheared((Player)player, heldItem, (Level)level, sheep2.blockPosition(), 1);
                    boolean bl = shearingSuccessful = !items.isEmpty();
                    if (shearingSuccessful && !player.getAbilities().instabuild) {
                        heldItem.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                    }
                    items.forEach(itemStack -> {
                        ItemEntity itemEntity = new ItemEntity((Level)level, sheep2.getX(), sheep2.getY(1.0), sheep2.getZ(), itemStack);
                        level.addFreshEntity((Entity)itemEntity);
                    });
                    if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                    }
                }
                if (shearingSuccessful) {
                    PROCESSED_ENTITY_IDS.add(sheep2.getId());
                    ++shearedCount;
                    if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86\u7f8a {}", (Object)sheep2.getId());
                    }
                    if (!heldItem.isEmpty()) continue;
                    break;
                }
                if (!((Boolean)ClientConfig.DEBUG.get()).booleanValue()) continue;
                Onekeyminer.LOGGER.debug("\u526a\u7f8a {} \u5931\u8d25\uff0c\u5c3d\u7ba1\u5b83\u5e94\u8be5\u662f\u53ef\u526a\u7684", (Object)sheep2.getId());
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406\u7f8a {} \u65f6\u51fa\u9519: {}", (Object)sheep2.getId(), (Object)e.getMessage());
            }
        }
        if (((Boolean)ClientConfig.DEBUG.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86 {} \u53ea\u7f8a", (Object)shearedCount);
        }
        if (shearedCount > 1 && ((Boolean)ClientConfig.SHOW_BLOCK_COUNT.get()).booleanValue()) {
            String messageStyle = (String)ClientConfig.MESSAGE_STYLE.get();
            if (messageStyle.equals("chat") || messageStyle.equals("both")) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.chain_shearing", (Object[])new Object[]{shearedCount}));
            }
            if (messageStyle.equals("actionbar") || messageStyle.equals("both")) {
                NetworkHandler.sendToPlayer(new ChainActionPacket("shearing", shearedCount), player);
            }
            return true;
        }
        return shearedCount > 1;
    }

    private static class BlockSearchNode {
        final BlockPos pos;
        final int depth;

        BlockSearchNode(BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }
    }
}

