/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.client;

import cn.onekeyminer.onekeyminer.Onekeyminer;
import cn.onekeyminer.onekeyminer.client.ClientUtils;
import cn.onekeyminer.onekeyminer.config.ClientConfig;
import cn.onekeyminer.onekeyminer.network.ChainModePacket;
import cn.onekeyminer.onekeyminer.network.NetworkHandler;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="onekeyminer", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class KeyBindings {
    public static final KeyMapping CHAIN_KEY = new KeyMapping("key.onekeyminer.chain", InputConstants.Type.KEYSYM, 96, "key.categories.onekeyminer");
    private static boolean chainModeActive = false;
    private static int packetCounter = 0;
    private static int frozenTimerCounter = 0;
    private static long lastCheckTime = 0L;
    private static Timer timer = null;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(CHAIN_KEY);
        MinecraftForge.EVENT_BUS.addListener(KeyBindings::onKeyInput);
    }

    public static void registerClientTick() {
        if (((Boolean)ClientConfig.REQUIRE_KEY_HOLD.get()).booleanValue()) {
            Onekeyminer.LOGGER.info("\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u5b9a\u65f6\u5668");
        }
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer("ChainModeTimer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                KeyBindings.handleTimerTick();
            }
        }, 0L, 100L);
        lastCheckTime = System.currentTimeMillis();
    }

    public static void onKeyInput(InputEvent.Key event) {
        if (CHAIN_KEY.consumeClick()) {
            Boolean requireKeyHold = (Boolean)ClientConfig.REQUIRE_KEY_HOLD.get();
            if (requireKeyHold == null) {
                if (((Boolean)ClientConfig.REQUIRE_KEY_HOLD.get()).booleanValue()) {
                    Onekeyminer.LOGGER.error("\u914d\u7f6e\u9879 requireKeyHold \u672a\u6b63\u786e\u521d\u59cb\u5316\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c false");
                }
                requireKeyHold = false;
            }
            if (requireKeyHold.booleanValue()) {
                chainModeActive = true;
                NetworkHandler.sendToServer(new ChainModePacket(true));
                packetCounter = 0;
                if (((Boolean)ClientConfig.REQUIRE_KEY_HOLD.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("Key pressed, activating chain mode (hold mode)");
                }
            } else {
                chainModeActive = !chainModeActive;
                NetworkHandler.sendToServer(new ChainModePacket(chainModeActive));
                if (((Boolean)ClientConfig.REQUIRE_KEY_HOLD.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("Key pressed, toggling chain mode: {}", (Object)chainModeActive);
                }
                if (chainModeActive) {
                    frozenTimerCounter = (Integer)ClientConfig.FROZEN_TIMER.get() * 1000;
                }
                ClientUtils.showStatusMessage(chainModeActive ? "message.onekeyminer.mode_enabled" : "message.onekeyminer.mode_disabled");
            }
            if (((Boolean)ClientConfig.REQUIRE_KEY_HOLD.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("Client chain mode state after key press: {}", (Object)chainModeActive);
            }
        }
    }

    public static void handleTimerTick() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null || minecraft.player == null || minecraft.level == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastCheckTime;
        lastCheckTime = currentTime;
        if (elapsed <= 0L || elapsed > 5000L) {
            return;
        }
        if (((Boolean)ClientConfig.REQUIRE_KEY_HOLD.get()).booleanValue()) {
            if (CHAIN_KEY.isDown()) {
                if ((packetCounter = (int)((long)packetCounter + elapsed)) >= 500) {
                    minecraft.execute(() -> NetworkHandler.sendToServer(new ChainModePacket(true)));
                    packetCounter = 0;
                }
            } else if (chainModeActive) {
                chainModeActive = false;
                minecraft.execute(() -> NetworkHandler.sendToServer(new ChainModePacket(false)));
            }
        } else if (chainModeActive && frozenTimerCounter > 0 && (frozenTimerCounter = (int)((long)frozenTimerCounter - elapsed)) <= 0) {
            chainModeActive = false;
            minecraft.execute(() -> {
                NetworkHandler.sendToServer(new ChainModePacket(false));
                ClientUtils.showStatusMessage("message.onekeyminer.mode_disabled");
            });
        }
    }
}

