/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue MAX_CHAIN_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> NON_CHAINABLE_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SEED_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue ENABLE_DIAGONAL_CHAINING;
    public static final ForgeConfigSpec.IntValue MAX_MINING_DEPTH;
    public static final ForgeConfigSpec.BooleanValue TELEPORT_DROPS_TO_PLAYER;
    public static final ForgeConfigSpec.BooleanValue IGNORE_TOOL_COMPATIBILITY;
    public static final ForgeConfigSpec.BooleanValue MATCH_BLOCK_STATE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_IN_CREATIVE;
    public static final ForgeConfigSpec.BooleanValue REQUIRE_SNEAKING;
    public static final ForgeConfigSpec.IntValue MAX_BLOCKS_IN_CHAIN;
    public static final ForgeConfigSpec.IntValue MAX_BLOCKS_IN_CHAIN_CREATIVE;
    public static final ForgeConfigSpec.IntValue MAX_CHAIN_DEPTH;

    public static boolean isBlockMineable(String blockId) {
        String resourceId = CommonConfig.convertToResourceId(blockId);
        for (String blacklistedBlock : (List)NON_CHAINABLE_BLOCKS.get()) {
            if (!resourceId.equals(blacklistedBlock)) continue;
            return false;
        }
        return true;
    }

    private static String convertToResourceId(String descriptionId) {
        String[] parts;
        if (descriptionId == null) {
            return "";
        }
        if (descriptionId.startsWith("block.") && (parts = descriptionId.split("\\.")).length >= 3) {
            return parts[1] + ":" + parts[2];
        }
        if (descriptionId.contains(":")) {
            return descriptionId;
        }
        if (!descriptionId.contains(".") && !descriptionId.contains(":")) {
            return "minecraft:" + descriptionId;
        }
        return descriptionId;
    }

    public static boolean isSeedBlacklisted(String seedId) {
        return ((List)SEED_BLACKLIST.get()).contains(seedId);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("\u901a\u7528\u914d\u7f6e||Common Config").push("general");
        MAX_CHAIN_BLOCKS = builder.comment("\u8fde\u9501\u64cd\u4f5c\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain operations").defineInRange("maxChainBlocks", 64, 1, 4096);
        NON_CHAINABLE_BLOCKS = builder.comment("\u4e0d\u5141\u8bb8\u8fde\u9501\u6316\u6398\u7684\u65b9\u5757\u9ed1\u540d\u5355||Blocks that should not be chain mined").defineList("nonChainableBlocks", () -> {
            ArrayList<String> defaults = new ArrayList<String>();
            defaults.add("minecraft:stone");
            defaults.add("minecraft:bedrock");
            return defaults;
        }, obj -> obj instanceof String);
        SEED_BLACKLIST = builder.comment("\u4e0d\u5141\u8bb8\u8fde\u9501\u79cd\u690d\u7684\u79cd\u5b50\u9ed1\u540d\u5355||Seeds that should not be chain planted").defineList("seedBlacklist", ArrayList::new, obj -> obj instanceof String);
        ENABLE_DIAGONAL_CHAINING = builder.comment("\u662f\u5426\u5141\u8bb8\u5bf9\u89d2\u7ebf\u8fde\u9501||Whether to allow diagonal chaining").define("enableDiagonalChaining", false);
        MAX_MINING_DEPTH = builder.comment("\u6700\u5927\u6316\u6398\u6df1\u5ea6||Maximum mining depth").defineInRange("maxMiningDepth", 16, 1, 64);
        TELEPORT_DROPS_TO_PLAYER = builder.comment("\u662f\u5426\u5c06\u8fde\u9501\u6316\u6398\u7684\u6389\u843d\u7269\u4f20\u9001\u5230\u73a9\u5bb6\u8eab\u4e0b||Whether to teleport the drops from chain mining to the player").define("teleportDropsToPlayer", false);
        IGNORE_TOOL_COMPATIBILITY = builder.comment("\u662f\u5426\u5ffd\u7565\u5de5\u5177\u517c\u5bb9\u6027\u68c0\u67e5||Whether to ignore tool compatibility checks").define("ignoreToolCompatibility", true);
        MATCH_BLOCK_STATE = builder.comment("\u662f\u5426\u5339\u914d\u5b8c\u6574\u7684\u65b9\u5757\u72b6\u6001||Whether to match the complete block state").define("matchBlockState", false);
        ENABLE_IN_CREATIVE = builder.comment("\u521b\u9020\u6a21\u5f0f\u662f\u5426\u542f\u7528\u8fde\u9501\u6316\u6398||Whether to enable chain mining in creative mode").define("enableInCreative", true);
        REQUIRE_SNEAKING = builder.comment("\u662f\u5426\u9700\u8981\u4e0b\u8e72\u624d\u80fd\u89e6\u53d1\u8fde\u9501\u6316\u6398||Whether to require sneaking to trigger chain mining").define("requireSneaking", false);
        MAX_BLOCKS_IN_CHAIN = builder.comment("\u5b58\u6d3b\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain mining in survival mode").defineInRange("maxBlocksInChain", 64, 1, 4096);
        MAX_BLOCKS_IN_CHAIN_CREATIVE = builder.comment("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain mining in creative mode").defineInRange("maxBlocksInChainCreative", 256, 1, 16384);
        MAX_CHAIN_DEPTH = builder.comment("\u6700\u5927\u8fde\u9501\u641c\u7d22\u6df1\u5ea6||Maximum chain search depth").defineInRange("maxChainDepth", 16, 1, 64);
        builder.pop();
        SPEC = builder.build();
    }
}

