/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.event;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="onekeyminer")
public class ServerEventHandler {
    private static final String DISCORD_LINK = "https://discord.gg/BNJuU33p";

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ServerEventHandler.class);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        MinecraftServer server;
        if (event.getEntity() instanceof ServerPlayer && (server = (player = (ServerPlayer)event.getEntity()).getServer()) != null) {
            server.executeBlocking(new Runnable(){

                @Override
                public void run() {
                    if (player.isRemoved() || !player.isAlive()) {
                        return;
                    }
                    CommandSourceStack source = server.createCommandSourceStack();
                    server.getCommands().performPrefixedCommand(source, "tellraw " + player.getScoreboardName() + " {\"translate\":\"message.onekeyminer.welcome\",\"color\":\"aqua\"}");
                    server.getCommands().performPrefixedCommand(source, "tellraw " + player.getScoreboardName() + " [{\"translate\":\"message.onekeyminer.discord.invite\",\"color\":\"green\"},{\"text\":\"https://discord.gg/BNJuU33p\",\"color\":\"blue\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"https://discord.gg/BNJuU33p\"},\"hoverEvent\":{\"action\":\"show_text\",\"contents\":{\"translate\":\"message.onekeyminer.discord.tooltip\"}}}]");
                }
            });
        }
    }
}

