/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.network;

import cn.onekeyminer.onekeyminer.Onekeyminer;
import cn.onekeyminer.onekeyminer.client.ClientPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ChainActionPacket {
    private final String actionType;
    private final int count;

    public ChainActionPacket(String actionType, int count) {
        this.actionType = actionType;
        this.count = count;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(this.actionType);
        buf.writeInt(this.count);
    }

    public static ChainActionPacket decode(FriendlyByteBuf buf) {
        String actionType = buf.readUtf();
        int count = buf.readInt();
        return new ChainActionPacket(actionType, count);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(ChainActionPacket packet, CustomPayloadEvent.Context context) {
        if (context == null) {
            Onekeyminer.LOGGER.error("ChainActionPacket.handleOnClient: context is null");
            return;
        }
        context.enqueueWork(() -> {
            try {
                ClientPacketHandler.handleChainActionPacket(packet);
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406\u8fde\u9501\u6d88\u606f\u6570\u636e\u5305\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    public String getActionType() {
        return this.actionType;
    }

    public int getCount() {
        return this.count;
    }
}

