/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.network;

import cn.onekeyminer.onekeyminer.capability.ChainModeCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ChainModePacket {
    final boolean active;

    public ChainModePacket(boolean active) {
        this.active = active;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    public static ChainModePacket decode(FriendlyByteBuf buf) {
        return new ChainModePacket(buf.readBoolean());
    }

    public static void handleOnServer(ChainModePacket packet, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer patt0$temp;
            if (context.getSender() != null && (patt0$temp = context.getSender()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = patt0$temp;
                ChainModeCapability.setChainMode(serverPlayer, packet.active);
            }
        });
    }

    public static void handleOnClient(ChainModePacket packet, CustomPayloadEvent.Context context) {
        Minecraft minecraft = Minecraft.getInstance();
        context.enqueueWork(() -> {
            if (minecraft.player == null) {
                return;
            }
            MutableComponent message = Component.translatable((String)(packet.active ? "message.onekeyminer.chain_mode_on" : "message.onekeyminer.chain_mode_off"));
            minecraft.player.displayClientMessage((Component)message, true);
        });
    }
}

