/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer.onekeyminer.network;

import cn.onekeyminer.onekeyminer.Onekeyminer;
import cn.onekeyminer.onekeyminer.config.ClientConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ConfigSyncPacket {
    private final String configKey;
    private final String configValue;

    public ConfigSyncPacket(String configKey, String configValue) {
        this.configKey = configKey;
        this.configValue = configValue;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(this.configKey);
        buf.writeUtf(this.configValue);
    }

    public static ConfigSyncPacket decode(FriendlyByteBuf buf) {
        String key = buf.readUtf();
        String value = buf.readUtf();
        return new ConfigSyncPacket(key, value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(ConfigSyncPacket packet, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            String key = packet.configKey;
            String value = packet.configValue;
            switch (key) {
                case "keyhold": {
                    ClientConfig.REQUIRE_KEY_HOLD.set((Object)Boolean.parseBoolean(value));
                    break;
                }
                case "showcount": {
                    ClientConfig.SHOW_BLOCK_COUNT.set((Object)Boolean.parseBoolean(value));
                    break;
                }
                case "messagestyle": {
                    ClientConfig.MESSAGE_STYLE.set((Object)value);
                    break;
                }
                default: {
                    Onekeyminer.LOGGER.warn("\u6536\u5230\u672a\u77e5\u914d\u7f6e\u952e: {}", (Object)key);
                }
            }
            Onekeyminer.LOGGER.debug("\u5ba2\u6237\u7aef\u914d\u7f6e\u5df2\u66f4\u65b0: {} = {}", (Object)key, (Object)value);
        });
    }
}

