/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.DirectionalExcavationUtils;
import cn.onekeyminer.ExcavatePacket;
import cn.onekeyminer.OKMConfig;
import cn.onekeyminer.OKMUtils;
import cn.onekeyminer.OKMUtils_Number_chains;
import cn.onekeyminer.OKM_Chain_farming;
import cn.onekeyminer.PlayerBreakEventUtils;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="onekeyminer")
public class OneKeyMiner {
    public static final SimpleChannel NETWORK_CHANNEL;
    public static final OKMConfig okmconfig;
    static final ForgeConfigSpec configSpec;
    private static final Set<ServerPlayer> playerSet;
    private static final String VERSION = "1";
    private static final String CHANNEL_NAME = "onekeyminer_network";
    static List<String> seedList;
    private static int nextNetworkId;

    public OneKeyMiner() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configSpec);
        modEventBus.register(ForgeConfig.class);
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        NETWORK_CHANNEL.registerMessage(OneKeyMiner.getNextNetworkId(), ExcavatePacket.class, ExcavatePacket::encode, ExcavatePacket::decode, ExcavatePacket::handle);
        System.out.println(Item.f_41373_);
    }

    public static int getNextNetworkId() {
        return nextNetworkId++;
    }

    public static void keyPressed(ServerPlayer player, boolean isPressed, boolean ignoredIsEmptyHanded, boolean b) {
        BlockPos playerPos = player.m_20183_();
        BlockState blockState = player.m_9236_().m_8055_(playerPos);
        ItemStack mainHandItem = player.m_21205_();
        if (isPressed) {
            if (mainHandItem.onBlockStartBreak(playerPos, (Player)player)) {
                switch ((Integer)OKMConfig.excavationMode.get()) {
                    case 1: {
                        OKMUtils.chainMine((ServerLevel)player.m_9236_(), player, playerPos, blockState);
                    }
                    case 2: {
                        DirectionalExcavationUtils.excavateInDirection(player.m_9236_(), player, blockState);
                    }
                    case 3: {
                        OKMUtils_Number_chains.excavateSphere(player.m_9236_(), player, playerPos, blockState);
                    }
                    case 4: {
                        PlayerBreakEventUtils.excavateSphere(player.m_9236_(), player, playerPos, blockState);
                    }
                }
            } else if (ignoredIsEmptyHanded) {
                playerSet.add(player);
            }
        } else {
            playerSet.remove(player);
        }
        OKM_Chain_farming.planting(isPressed);
    }

    static boolean isSeed(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        ResourceLocation itemRegName = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return itemRegName != null && !seedList.contains(itemRegName.toString());
    }

    static {
        playerSet = new HashSet<ServerPlayer>();
        nextNetworkId = 0;
        NETWORK_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("onekeyminer", CHANNEL_NAME)).clientAcceptedVersions(VERSION::equals).serverAcceptedVersions(VERSION::equals).networkProtocolVersion(() -> VERSION).simpleChannel();
        Pair specPair = new ForgeConfigSpec.Builder().configure(OKMConfig::new);
        configSpec = (ForgeConfigSpec)specPair.getRight();
        okmconfig = (OKMConfig)specPair.getLeft();
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class KeyInputHandler {
        private static boolean isKeyPressed = false;

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null && minecraft.f_91074_ != null) {
                boolean is_empty_handed;
                LocalPlayer player = minecraft.f_91074_;
                ItemStack mainHandItem = player.m_21205_();
                ItemStack offHandItem = player.m_21206_();
                boolean hasSeed = OneKeyMiner.isSeed(mainHandItem);
                boolean bl = is_empty_handed = mainHandItem.m_41619_() && offHandItem.m_41619_();
                if (ClientEventHandler.KEY_01.m_90857_()) {
                    if (!isKeyPressed) {
                        isKeyPressed = true;
                        KeyInputHandler.sendPacket(true, !is_empty_handed, hasSeed);
                    }
                } else if (isKeyPressed) {
                    isKeyPressed = false;
                    KeyInputHandler.sendDefaultPacket();
                }
            }
        }

        private static void sendPacket(boolean start, boolean hasItem, boolean hasSeed) {
            NETWORK_CHANNEL.sendToServer((Object)new ExcavatePacket(start, hasItem, hasSeed));
        }

        private static void sendDefaultPacket() {
            NETWORK_CHANNEL.sendToServer((Object)new ExcavatePacket(false, false, false));
        }

        @SubscribeEvent
        public void onBlockBreak(BlockEvent.BreakEvent event) {
            ServerPlayer player;
            if (!event.getLevel().m_5776_() && playerSet.contains(player = (ServerPlayer)event.getPlayer())) {
                switch ((Integer)OKMConfig.excavationMode.get()) {
                    case 1: {
                        OKMUtils.chainMine((ServerLevel)player.m_9236_(), player, event.getPos(), event.getState());
                    }
                    case 2: {
                        DirectionalExcavationUtils.excavateInDirection(event.getPlayer().m_9236_(), player, event.getState());
                    }
                    case 3: {
                        OKMUtils_Number_chains.excavateSphere((Level)event.getLevel(), (ServerPlayer)event.getPlayer(), event.getPos(), event.getState());
                    }
                    case 4: {
                        PlayerBreakEventUtils.excavateSphere(event.getPlayer().m_9236_(), player, event.getPos(), event.getState());
                    }
                }
                playerSet.remove(player);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLoadComplete(FMLLoadCompleteEvent event) {
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onServerStarting(PlayerInteractEvent.RightClickBlock event) {
            Player player;
            ItemStack mainHandItem;
            boolean hasSeed;
            if (!event.isCanceled() && (hasSeed = OneKeyMiner.isSeed(mainHandItem = (player = event.getEntity()).m_21205_())) && OKM_Chain_farming.isPressed) {
                OKM_Chain_farming.planting0(player, player.m_9236_(), event.getPos(), player.m_21205_());
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEventHandler {
        public static final KeyMapping KEY_01 = new KeyMapping("key.onekeyminer.key1_unique_name", InputConstants.Type.KEYSYM, 96, "key.categories.gameplay");

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(KEY_01);
        }
    }

    @Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonProxy {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            if (configSpec.isLoaded()) {
                seedList = (List)OKMConfig.blacklistedSeedItems.get();
            }
        }
    }
}

