/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OKMConfig;
import cn.onekeyminer.OKMUtils;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PlayerBreakEventUtils {
    private static boolean isProcessing = false;

    public static void excavateSphere(Level world, ServerPlayer player, BlockPos centerPos, BlockState targetBlock) {
        int exp = 0;
        if (isProcessing) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        isProcessing = true;
        int maxChainCount = (Integer)OKMConfig.max_count.get();
        boolean protectDurability = (Boolean)OKMConfig.toolProtectionMode.get();
        double hungerThreshold = (Double)OKMConfig.SaturationdeductionThreshold.get();
        FoodData foodData = player.m_36324_();
        if ((double)foodData.m_38702_() < hungerThreshold) {
            isProcessing = false;
            return;
        }
        ItemStack tool = player.m_21205_();
        double toolDurabilityThreshold = (Double)OKMConfig.toolDurabilityThreshold.get();
        if (protectDurability && tool.m_41763_()) {
            double durability;
            double d = durability = tool.m_41776_() > 1 ? (double)tool.m_41773_() / (double)tool.m_41776_() : (double)tool.m_41773_();
            if (durability >= toolDurabilityThreshold) {
                isProcessing = false;
                return;
            }
        }
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(centerPos);
        visited.add(centerPos);
        HashSet<BlockPos> toBreak = new HashSet<BlockPos>();
        int chainCount = 0;
        while (!queue.isEmpty() && chainCount < maxChainCount) {
            BlockPos pos = (BlockPos)queue.poll();
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() != targetBlock.m_60734_() || !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) continue;
            toBreak.add(pos);
            ++chainCount;
            for (BlockPos neighbor : OKMUtils.getNeighborBlockPoses(pos, world, blockState -> blockState.m_60734_() == targetBlock.m_60734_())) {
                if (visited.contains(neighbor)) continue;
                queue.add(neighbor);
                visited.add(neighbor);
            }
        }
        for (BlockPos pos : toBreak) {
            BlockState state = world.m_8055_(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (Player)player);
            boolean eventPosted = MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)tool);
            for (ItemStack drop : drops) {
                player.m_150109_().m_36054_(drop);
            }
            world.m_46953_(pos, false, (Entity)player);
            tool.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
            if ((exp += event.getExpToDrop()) <= 0) continue;
            world.m_7967_((Entity)new ExperienceOrb(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), exp));
        }
        isProcessing = false;
    }
}

