/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FungusBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.NetherSproutsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

public class ChainAPI {
    public static List<BlockPos> computeMiningPositions(ServerPlayerEntity player, ServerWorld level, BlockPos startPos, BlockState startState, ItemStack tool) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        if (!ChainModeCapability.isChainModeActive(player)) {
            return result;
        }
        if (startState.func_196958_f()) {
            return result;
        }
        if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.func_225608_bj_()) {
            return result;
        }
        if (player.func_184812_l_() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
            return result;
        }
        if (!player.func_184812_l_() && (double)player.func_71024_bL().func_75116_a() < (Double)ServerConfig.INSTANCE.hungerThreshold.get()) {
            return result;
        }
        Block block = startState.func_177230_c();
        if (!CommonConfig.INSTANCE.isBlockMineable(block)) {
            return result;
        }
        if (!((Boolean)CommonConfig.INSTANCE.ignoreToolCompatibility.get()).booleanValue() && !player.func_234569_d_(startState)) {
            return result;
        }
        if (!player.func_184812_l_() && tool.func_77984_f()) {
            double durabilityProtection = (Double)ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.func_77952_i() >= (double)tool.func_77958_k() - durabilityProtection) {
                return result;
            }
        }
        try {
            result = ChainHandler.computeMiningPositions(player, level, startPos, startState, tool);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.func_180495_p(startPos).func_177230_c() == startState.func_177230_c()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.func_177984_a(), startPos.func_177977_b(), startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177974_f(), startPos.func_177976_e()}) {
                if (result.size() >= 10) break;
                if (level.func_180495_p(neighbor).func_177230_c() != startState.func_177230_c()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computeInteractionPositions(ServerPlayerEntity player, ServerWorld level, BlockPos startPos, BlockState targetState, Hand hand) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return result;
        }
        if (heldItem.func_77984_f() && heldItem.func_77952_i() >= heldItem.func_77958_k() - 1) {
            return result;
        }
        try {
            result = InteractionHandler.computeInteractionPositions(player, level, startPos, targetState, hand);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.func_180495_p(startPos).func_177230_c() == targetState.func_177230_c()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.func_177984_a(), startPos.func_177977_b(), startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177974_f(), startPos.func_177976_e()}) {
                if (result.size() >= 10) break;
                if (level.func_180495_p(neighbor).func_177230_c() != targetState.func_177230_c()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computePlantingPositions(ServerPlayerEntity player, ServerWorld level, BlockPos startPos, BlockState targetState, ItemStack seedItem) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || seedItem == null) {
            return result;
        }
        try {
            result = PlantingHandler.computePlantingPositions(player, level, startPos, targetState, seedItem);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (!ChainAPI.isPlantableItem(seedItem)) {
                return result;
            }
            if (ChainAPI.canPlantAt((World)level, startPos, level.func_180495_p(startPos), seedItem)) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.func_177984_a(), startPos.func_177977_b(), startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177974_f(), startPos.func_177976_e()}) {
                if (result.size() >= 10) break;
                if (!ChainAPI.canPlantAt((World)level, neighbor, level.func_180495_p(neighbor), seedItem)) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    private static boolean canPlantAt(World level, BlockPos pos, BlockState state, ItemStack seedItem) {
        if (!level.func_175623_d(pos)) {
            return false;
        }
        BlockPos below = pos.func_177977_b();
        BlockState belowState = level.func_180495_p(below);
        return ChainAPI.canPlantOnSurface(seedItem.func_77973_b(), belowState);
    }

    private static boolean canPlantOnSurface(Item item, BlockState surfaceState) {
        if (surfaceState == null) {
            return false;
        }
        Block surfaceBlock = surfaceState.func_177230_c();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.func_179223_d();
            if (block instanceof CropsBlock) {
                return surfaceBlock == Blocks.field_150458_ak;
            }
            if (block instanceof SaplingBlock || block instanceof FlowerBlock) {
                return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_196658_i || surfaceBlock == Blocks.field_196661_l || surfaceBlock == Blocks.field_150391_bh;
            }
            if (block instanceof MushroomBlock) {
                return surfaceBlock == Blocks.field_150391_bh;
            }
            if (item == Items.field_151174_bG || item == Items.field_151172_bF || item == Items.field_151014_N || item == Items.field_185163_cU) {
                return surfaceBlock == Blocks.field_150458_ak;
            }
        }
        return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_196658_i || surfaceBlock == Blocks.field_196661_l || surfaceBlock == Blocks.field_150354_m || surfaceBlock == Blocks.field_150425_aM || surfaceBlock == Blocks.field_150391_bh || surfaceBlock instanceof FarmlandBlock;
    }

    private static boolean isPlantableItem(ItemStack stack) {
        BlockItem blockItem;
        Block block;
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (CommonConfig.INSTANCE.isSeedBlacklisted(item)) {
            return false;
        }
        if (item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).func_179223_d()) instanceof CropsBlock || block instanceof SaplingBlock || block instanceof BushBlock || block instanceof FlowerBlock || block instanceof TallFlowerBlock || block instanceof CactusBlock || block instanceof TallGrassBlock || block instanceof FungusBlock || block instanceof NetherSproutsBlock || block instanceof CocoaBlock || block instanceof SugarCaneBlock || block instanceof NetherWartBlock)) {
            return true;
        }
        String name = item.toString().toLowerCase();
        if (name.contains("seed") || name.contains("sapling") || name.contains("seedling") || name.contains("plant")) {
            return true;
        }
        return item == Items.field_151014_N || item == Items.field_185163_cU || item == Items.field_151080_bb || item == Items.field_151081_bc || item == Items.field_151174_bG || item == Items.field_151172_bF || item == Items.field_222112_pR || item == Items.field_234722_bw_ || item == Items.field_234723_bx_ || item == Items.field_196130_bo || item == Items.field_222066_kO || item == Items.field_222068_kQ || item == Items.field_222065_kN || item == Items.field_221774_cw || item == Items.field_221601_aC;
    }
}

