/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.capability;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;

public class ChainModeCapability {
    private static final String CHAIN_MODE_TAG = "onekeyminer:chain_mode";

    public static boolean isChainModeActive(ServerPlayerEntity player) {
        try {
            CompoundNBT root = player.getPersistentData();
            String tag = "PlayerPersisted";
            if (root.func_74764_b(tag)) {
                CompoundNBT persisted = root.func_74775_l(tag);
                return persisted.func_74767_n(CHAIN_MODE_TAG);
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.debug("\u68c0\u67e5\u8fde\u9501\u6a21\u5f0f\u65f6\u8bfb\u53d6\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519: {}", (Object)e.getMessage());
        }
        return false;
    }

    public static void setChainMode(ServerPlayerEntity player, boolean active) {
        try {
            CompoundNBT root = player.getPersistentData();
            String tag = "PlayerPersisted";
            CompoundNBT persisted = root.func_74764_b(tag) ? root.func_74775_l(tag) : new CompoundNBT();
            persisted.func_74757_a(CHAIN_MODE_TAG, active);
            root.func_218657_a(tag, (INBT)persisted);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8bbe\u7f6e\u8fde\u9501\u6a21\u5f0f\u6301\u4e45\u5316\u6570\u636e\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity originalPlayer = event.getOriginal();
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity newPlayer = (PlayerEntity)event.getEntity();
            if (event.isWasDeath()) {
                String tag;
                boolean wasChainActive = false;
                try {
                    CompoundNBT origRoot = originalPlayer.getPersistentData();
                    tag = "PlayerPersisted";
                    if (origRoot.func_74764_b(tag)) {
                        CompoundNBT origPersisted = origRoot.func_74775_l(tag);
                        wasChainActive = origPersisted.func_74767_n(CHAIN_MODE_TAG);
                    }
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u8bfb\u53d6\u539f\u59cb\u73a9\u5bb6\u8fde\u9501\u6a21\u5f0f\u6570\u636e\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                }
                try {
                    CompoundNBT root = newPlayer.getPersistentData();
                    tag = "PlayerPersisted";
                    CompoundNBT persisted = root.func_74764_b(tag) ? root.func_74775_l(tag) : new CompoundNBT();
                    persisted.func_74757_a(CHAIN_MODE_TAG, wasChainActive);
                    root.func_218657_a(tag, (INBT)persisted);
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u590d\u5236\u73a9\u5bb6\u8fde\u9501\u6a21\u5f0f\u6570\u636e\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

