/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainHandler {
    private static final Set<BlockPos> CURRENTLY_MINING = new HashSet<BlockPos>();
    private static int XPS = 0;

    public static boolean tryChainMine(ServerPlayerEntity player, BlockPos pos, BlockState state, ItemStack tool) {
        CURRENTLY_MINING.clear();
        if (player == null || pos == null || state == null || tool == null) {
            Onekeyminer.LOGGER.debug("\u8fde\u9501\u6316\u6398\u53c2\u6570\u65e0\u6548");
            return false;
        }
        if (!ChainHandler.validateChainMiningConditions(player, pos, state, tool)) {
            return false;
        }
        String blockId = state.func_177230_c().func_149739_a();
        String blockName = state.func_177230_c().func_235333_g_().getString();
        int blocksMined = ChainHandler.performChainMining(player, pos, state, tool);
        if (blocksMined > 0) {
            ChainHandler.sendFeedback(player, blocksMined);
        }
        return blocksMined > 0;
    }

    public static List<BlockPos> computeMiningPositions(ServerPlayerEntity player, ServerWorld level, BlockPos startPos, BlockState startState, ItemStack tool) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        int maxBlocks = player.func_184812_l_() ? ((Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get()).intValue() : ((Integer)CommonConfig.INSTANCE.maxBlocksInChain.get()).intValue();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = (Boolean)CommonConfig.INSTANCE.matchBlockState.get();
        boolean matchseedState = (Boolean)CommonConfig.INSTANCE.matchseedBlockState.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!toMine.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                BlockState currentState;
                ++iterations;
                BlockPos currentPos = (BlockPos)toMine.poll();
                if (minedPositions.contains(currentPos) || Math.abs(currentPos.func_177956_o() - startPos.func_177956_o()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.func_180495_p(currentPos), matchFullState, matchseedState)) continue;
                minedPositions.add(currentPos);
                result.add(currentPos);
                for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                    if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - result.size()) continue;
                    toMine.add(neighbor);
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u6316\u6398\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private static boolean validateChainMiningConditions(ServerPlayerEntity player, BlockPos pos, BlockState state, ItemStack tool) {
        if (!ChainModeCapability.isChainModeActive(player)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u8fde\u9501\u6a21\u5f0f\u672a\u542f\u7528");
            }
            return false;
        }
        if (state.func_196958_f()) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.func_225608_bj_()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u9700\u8981\u4e0b\u8e72\u4f46\u73a9\u5bb6\u672a\u4e0b\u8e72");
            }
            return false;
        }
        if (player.func_184812_l_() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u672a\u542f\u7528");
            }
            return false;
        }
        if (!player.func_184812_l_() && (double)player.func_71024_bL().func_75116_a() < (Double)ServerConfig.INSTANCE.hungerThreshold.get()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u73a9\u5bb6\u9965\u997f\u5ea6\u4e0d\u8db3: {} < {}", (Object)player.func_71024_bL().func_75116_a(), ServerConfig.INSTANCE.hungerThreshold.get());
            }
            return false;
        }
        Block blockId = state.func_177230_c();
        String blockName = state.func_177230_c().func_235333_g_().getString();
        if (!CommonConfig.INSTANCE.isBlockMineable(blockId)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u65b9\u5757\u5728\u4e0d\u53ef\u6316\u6398\u5217\u8868\u4e2d: {} (\u5185\u90e8ID: {})", (Object)blockName, (Object)blockId);
            }
            return false;
        }
        if (!((Boolean)CommonConfig.INSTANCE.ignoreToolCompatibility.get()).booleanValue() && !player.func_234569_d_(state)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u5de5\u5177\u4e0d\u517c\u5bb9: {}", (Object)tool.func_77973_b().func_77658_a());
            }
            return false;
        }
        if (!player.func_184812_l_() && tool.func_77984_f()) {
            Double durabilityProtection = (Double)ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.func_77952_i() >= (double)tool.func_77958_k() - durabilityProtection) {
                if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u5de5\u5177\u8010\u4e45\u5ea6\u4e0d\u8db3\u8fdb\u884c\u8fde\u9501\u6316\u6398");
                }
                return false;
            }
        }
        return true;
    }

    private static int performChainMining(ServerPlayerEntity player, BlockPos startPos, BlockState startState, ItemStack tool) {
        World level = player.field_70170_p;
        ServerWorld serverLevel = (ServerWorld)level;
        int maxBlocks = player.func_184812_l_() ? ((Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get()).intValue() : ((Integer)CommonConfig.INSTANCE.maxBlocksInChain.get()).intValue();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = (Boolean)CommonConfig.INSTANCE.matchBlockState.get();
        boolean matchseedState = (Boolean)CommonConfig.INSTANCE.matchseedBlockState.get();
        boolean teleportDrops = (Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        int blocksMined = 0;
        XPS = 0;
        while (!toMine.isEmpty() && blocksMined < maxBlocks) {
            boolean blockDestroyed;
            BlockState currentState;
            BlockPos currentPos = (BlockPos)toMine.poll();
            if (minedPositions.contains(currentPos) || Math.abs(currentPos.func_177956_o() - startPos.func_177956_o()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.func_180495_p(currentPos), matchFullState, matchseedState)) continue;
            minedPositions.add(currentPos);
            if (teleportDrops) {
                blockDestroyed = ChainHandler.breakBlockWithTeleport(serverLevel, currentPos, currentState, player, tool);
            } else {
                TileEntity blockEntity = level.func_175625_s(currentPos);
                LootContext.Builder builder = new LootContext.Builder(serverLevel).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)currentPos)).func_216015_a(LootParameters.field_216289_i, (Object)tool).func_216021_b(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)blockEntity);
                List drops = currentState.func_215693_a(builder);
                boolean hasSilkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0;
                int xp = 0;
                int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
                xp = currentState.func_177230_c().getExpDrop(currentState, (IWorldReader)level, currentPos, fortuneLevel, hasSilkTouch ? 1 : 0);
                blockDestroyed = serverLevel.func_225521_a_(currentPos, false, (Entity)player);
                if (!blockDestroyed) continue;
                for (ItemStack itemStack : drops) {
                    if (itemStack.func_190926_b()) continue;
                    Block.func_180635_a((World)level, (BlockPos)currentPos, (ItemStack)itemStack);
                }
                if (xp > 0) {
                    ExperienceOrbEntity orb = new ExperienceOrbEntity(level, (double)currentPos.func_177958_n() + 0.5, (double)currentPos.func_177956_o() + 0.5, (double)currentPos.func_177952_p() + 0.5, xp);
                    level.func_217376_c((Entity)orb);
                }
                level.func_184133_a(null, currentPos, currentState.func_215695_r().func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!player.func_184812_l_() && tool.func_77984_f()) {
                    tool.func_222118_a(1, (LivingEntity)player, p -> p.func_213361_c(EquipmentSlotType.MAINHAND));
                    if (tool.func_190926_b()) break;
                }
            }
            if (!blockDestroyed) continue;
            ++blocksMined;
            for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - blocksMined) continue;
                toMine.add(neighbor);
            }
        }
        if (teleportDrops && XPS > 0) {
            BlockPos dropPos = player.func_233580_cy_();
            ExperienceOrbEntity orb = new ExperienceOrbEntity(level, (double)dropPos.func_177958_n() + 0.5, (double)dropPos.func_177956_o() + 0.5, (double)dropPos.func_177952_p() + 0.5, XPS);
            level.func_217376_c((Entity)orb);
            XPS = 0;
        }
        return blocksMined;
    }

    private static boolean isBlockMatching(BlockState reference, BlockState target, boolean matchFullState, boolean matchSeedState) {
        if (target.func_196958_f()) {
            return false;
        }
        if (matchFullState && !(target.func_177230_c() instanceof CropsBlock) || matchSeedState && target.func_177230_c() instanceof CropsBlock) {
            return reference.equals(target);
        }
        if (reference.func_177230_c() == target.func_177230_c()) {
            if (ChainHandler.hasSpecialMatchingRules(reference.func_177230_c())) {
                return ChainHandler.matchSpecialBlockProperties(reference, target);
            }
            return true;
        }
        return false;
    }

    private static boolean hasSpecialMatchingRules(Block block) {
        String blockId = block.func_149739_a();
        return blockId.contains("ore") || blockId.contains("log") || blockId.contains("wood") || blockId.contains("leaves");
    }

    private static boolean matchSpecialBlockProperties(BlockState reference, BlockState target) {
        if (reference.func_177230_c().func_149739_a().contains("ore")) {
            return true;
        }
        if (reference.func_177230_c().func_149739_a().contains("log") || reference.func_177230_c().func_149739_a().contains("wood")) {
            String refType = ChainHandler.extractWoodType(reference.func_177230_c().func_149739_a());
            String targetType = ChainHandler.extractWoodType(target.func_177230_c().func_149739_a());
            return refType.equals(targetType);
        }
        if (reference.func_177230_c().func_149739_a().contains("leaves")) {
            String refType = ChainHandler.extractWoodType(reference.func_177230_c().func_149739_a());
            String targetType = ChainHandler.extractWoodType(target.func_177230_c().func_149739_a());
            return refType.equals(targetType);
        }
        return true;
    }

    private static String extractWoodType(String blockId) {
        for (String woodType : new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson", "warped", "mangrove", "cherry"}) {
            if (!blockId.contains(woodType)) continue;
            return woodType;
        }
        return blockId;
    }

    private static boolean breakBlockWithTeleport(ServerWorld level, BlockPos pos, BlockState state, ServerPlayerEntity player, ItemStack tool) {
        if (level == null || player == null) {
            return false;
        }
        BlockPos dropPos = player.func_233580_cy_();
        try {
            TileEntity blockEntity = level.func_175625_s(pos);
            LootContext.Builder builder = new LootContext.Builder(level).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)tool).func_216021_b(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)blockEntity);
            List drops = state.func_215693_a(builder);
            boolean hasSilkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0;
            int xp = 0;
            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
            xp = state.func_177230_c().getExpDrop(state, (IWorldReader)level, pos, fortuneLevel, hasSilkTouch ? 1 : 0);
            boolean broken = level.func_225521_a_(pos, false, (Entity)player);
            if (!broken) {
                return false;
            }
            for (ItemStack itemStack : drops) {
                if (itemStack.func_190926_b()) continue;
                Block.func_180635_a((World)level, (BlockPos)dropPos, (ItemStack)itemStack);
            }
            if (xp > 0 && !hasSilkTouch) {
                XPS += xp;
            }
            level.func_184133_a(null, pos, state.func_215695_r().func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!player.func_184812_l_() && tool.func_77984_f()) {
                tool.func_222118_a(1, (LivingEntity)player, p -> p.func_213361_c(EquipmentSlotType.MAINHAND));
                if (tool.func_190926_b()) {
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u4f20\u9001\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(14);
        neighbors.add(pos.func_177984_a());
        neighbors.add(pos.func_177977_b());
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177976_e());
        if (includeDiagonal) {
            neighbors.add(pos.func_177978_c().func_177974_f());
            neighbors.add(pos.func_177978_c().func_177976_e());
            neighbors.add(pos.func_177968_d().func_177974_f());
            neighbors.add(pos.func_177968_d().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c());
            neighbors.add(pos.func_177984_a().func_177968_d());
            neighbors.add(pos.func_177984_a().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c());
            neighbors.add(pos.func_177977_b().func_177968_d());
            neighbors.add(pos.func_177977_b().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177976_e());
        }
        return neighbors;
    }

    private static void sendFeedback(ServerPlayerEntity player, int blocksMined) {
        NetworkHandler.sendToPlayer(new ChainActionPacket("mining", blocksMined), player);
    }
}

