/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class InteractionHandler {
    private static final Set<BlockPos> PROCESSED_POSITIONS = new HashSet<BlockPos>();
    private static final Set<Integer> PROCESSED_ENTITY_IDS = new HashSet<Integer>();

    public static boolean isValidInteractionTool(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof ShearsItem;
    }

    public static List<BlockPos> computeInteractionPositions(ServerPlayerEntity player, ServerWorld level, BlockPos startPos, BlockState targetState, Hand hand) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return result;
        }
        if (targetState.func_196958_f()) {
            return result;
        }
        int maxBlocks = player.func_184812_l_() ? ((Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get()).intValue() : ((Integer)CommonConfig.INSTANCE.maxBlocksInChain.get()).intValue();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean includeDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(new BlockSearchNode(startPos, 0));
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!queue.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                ++iterations;
                BlockSearchNode node = (BlockSearchNode)queue.poll();
                BlockPos pos = node.pos;
                if (node.depth > maxDepth || visited.contains(pos)) continue;
                visited.add(pos);
                BlockState state = level.func_180495_p(pos);
                if (!InteractionHandler.isMatchingBlock(state, targetState)) continue;
                result.add(pos);
                for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                    if (visited.contains(neighbor)) continue;
                    queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u4ea4\u4e92\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    @Deprecated
    public static void handleChainInteraction(ServerPlayerEntity player, PlayerInteractEvent.RightClickBlock event) {
        InteractionHandler.tryChainInteraction(player, (ServerWorld)event.getWorld(), event.getPos(), event.getFace(), event.getHitVec().func_216347_e(), event.getHand());
    }

    public static boolean tryChainInteraction(ServerPlayerEntity player, ServerWorld level, BlockPos pos, Direction side, Vector3d hitVec, Hand hand) {
        PROCESSED_POSITIONS.clear();
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return false;
        }
        BlockState initialState = level.func_180495_p(pos);
        if (initialState.func_196958_f()) {
            return false;
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u4ea4\u4e92: {}", (Object)initialState.func_177230_c().func_149739_a());
        }
        BlockRayTraceResult initialHit = new BlockRayTraceResult(hitVec, side, pos, false);
        int maxBlocks = player.func_184812_l_() ? ((Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get()).intValue() : ((Integer)CommonConfig.INSTANCE.maxBlocksInChain.get()).intValue();
        boolean includeDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int processedCount = InteractionHandler.floodFillInteraction(player, level, initialState, initialHit, hand, maxBlocks, (Integer)CommonConfig.INSTANCE.maxChainDepth.get(), includeDiagonal);
        if (processedCount > 0) {
            NetworkHandler.sendToPlayer(new ChainActionPacket("interaction", processedCount), player);
            return true;
        }
        return false;
    }

    private static int floodFillInteraction(ServerPlayerEntity player, ServerWorld level, BlockState targetState, BlockRayTraceResult initialHit, Hand hand, int maxBlocks, int maxDepth, boolean includeDiagonal) {
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        queue.add(new BlockSearchNode(initialHit.func_216350_a(), 0));
        int processedCount = 0;
        ItemStack heldItem = player.func_184586_b(hand);
        while (!queue.isEmpty() && processedCount < maxBlocks) {
            BlockState state;
            BlockSearchNode node = (BlockSearchNode)queue.poll();
            BlockPos pos = node.pos;
            if (node.depth > maxDepth || PROCESSED_POSITIONS.contains(pos) || !InteractionHandler.isMatchingBlock(state = level.func_180495_p(pos), targetState)) continue;
            if (heldItem.func_190926_b() || heldItem.func_77952_i() >= heldItem.func_77958_k() - 1) break;
            PROCESSED_POSITIONS.add(pos);
            BlockRayTraceResult hit = new BlockRayTraceResult(initialHit.func_216347_e(), initialHit.func_216354_b(), pos, false);
            ItemUseContext context = new ItemUseContext((PlayerEntity)player, hand, hit);
            ActionResultType result = heldItem.func_196084_a(context);
            if (result.func_226246_a_()) {
                ++processedCount;
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u6210\u529f: {}", (Object)pos);
                }
            }
            for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
            }
        }
        Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u65b9\u5757", (Object)processedCount);
        return processedCount;
    }

    private static boolean isMatchingBlock(BlockState state, BlockState target) {
        if (state.func_196958_f() || target.func_196958_f()) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.matchBlockState.get()).booleanValue() && !(target.func_177230_c() instanceof CropsBlock) || ((Boolean)CommonConfig.INSTANCE.matchseedBlockState.get()).booleanValue() && target.func_177230_c() instanceof CropsBlock) {
            return state.equals(target);
        }
        return state.func_177230_c() == target.func_177230_c();
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.func_177984_a());
        neighbors.add(pos.func_177977_b());
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177976_e());
        if (includeDiagonal) {
            neighbors.add(pos.func_177978_c().func_177974_f());
            neighbors.add(pos.func_177978_c().func_177976_e());
            neighbors.add(pos.func_177968_d().func_177974_f());
            neighbors.add(pos.func_177968_d().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c());
            neighbors.add(pos.func_177984_a().func_177968_d());
            neighbors.add(pos.func_177984_a().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c());
            neighbors.add(pos.func_177977_b().func_177968_d());
            neighbors.add(pos.func_177977_b().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177976_e());
        }
        return neighbors;
    }

    public static boolean tryChainShearing(ServerPlayerEntity player, SheepEntity targetSheep, Hand hand) {
        PROCESSED_ENTITY_IDS.clear();
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ShearsItem)) {
            return false;
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u526a\u7f8a\u6bdb: {}", (Object)targetSheep.func_145782_y());
        }
        int maxEntities = player.func_184812_l_() ? ((Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get()).intValue() : ((Integer)CommonConfig.INSTANCE.maxBlocksInChain.get()).intValue();
        double searchRadius = (double)((Integer)CommonConfig.INSTANCE.maxChainDepth.get()).intValue() * 0.5;
        if (((Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get()).booleanValue()) {
            searchRadius *= 1.5;
        }
        PROCESSED_ENTITY_IDS.add(targetSheep.func_145782_y());
        boolean teleportDrops = (Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        BlockPos playerPos = player.func_233580_cy_();
        ServerWorld level = (ServerWorld)player.field_70170_p;
        AxisAlignedBB searchBox = new AxisAlignedBB(targetSheep.func_226277_ct_() - searchRadius, targetSheep.func_226278_cu_() - searchRadius, targetSheep.func_226281_cx_() - searchRadius, targetSheep.func_226277_ct_() + searchRadius, targetSheep.func_226278_cu_() + searchRadius, targetSheep.func_226281_cx_() + searchRadius);
        List allSheepInArea = level.func_175647_a(SheepEntity.class, searchBox, sheep -> sheep.func_70089_S() && sheep.func_230262_K__() && !PROCESSED_ENTITY_IDS.contains(sheep.func_145782_y()));
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u627e\u5230 {} \u53ea\u53ef\u526a\u7f8a", (Object)(allSheepInArea.size() + 1));
        }
        int shearedCount = 1;
        ArrayList<UUID> shearingUuids = new ArrayList<UUID>();
        shearingUuids.add(targetSheep.func_110124_au());
        for (SheepEntity s : allSheepInArea) {
            shearingUuids.add(s.func_110124_au());
        }
        try {
            String key = player.func_110124_au().toString();
            ChainPositionStore.setShearingEntityUuids(key, shearingUuids);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.debug("\u5199\u5165\u526a\u7f8a UUID \u5217\u8868\u5230 ChainPositionStore \u65f6\u51fa\u9519: {}", (Object)e.getMessage());
        }
        for (SheepEntity sheep2 : allSheepInArea) {
            if (shearedCount >= maxEntities) break;
            try {
                if (!sheep2.isShearable(heldItem, player.field_70170_p, sheep2.func_233580_cy_()) || !sheep2.func_230262_K__()) continue;
                boolean wasShearable = sheep2.func_230262_K__();
                int woolColorBefore = sheep2.func_175509_cj().func_196059_a();
                boolean shearingSuccessful = false;
                if (teleportDrops) {
                    double originalX = sheep2.func_226277_ct_();
                    double originalY = sheep2.func_226278_cu_();
                    double originalZ = sheep2.func_226281_cx_();
                    try {
                        sheep2.func_70107_b((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p());
                        if (sheep2.func_230262_K__()) {
                            List items = sheep2.onSheared((PlayerEntity)player, heldItem, (World)level, sheep2.func_233580_cy_(), 1);
                            boolean bl = shearingSuccessful = !items.isEmpty();
                            if (shearingSuccessful && !player.field_71075_bZ.field_75098_d) {
                                heldItem.func_222118_a(1, (LivingEntity)player, p -> p.func_213361_c(player.func_184614_ca().getEquipmentSlot()));
                            }
                            items.forEach(itemStack -> {
                                ItemEntity itemEntity = new ItemEntity((World)level, sheep2.func_226277_ct_(), sheep2.func_226283_e_(1.0), sheep2.func_226281_cx_(), itemStack);
                                level.func_217376_c((Entity)itemEntity);
                            });
                            if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                                Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                            }
                        }
                        sheep2.func_70107_b(originalX, originalY, originalZ);
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u4f20\u9001\u7f8a\u6bdb\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                        sheep2.func_70107_b(originalX, originalY, originalZ);
                    }
                } else if (sheep2.func_230262_K__()) {
                    List items = sheep2.onSheared((PlayerEntity)player, heldItem, (World)level, sheep2.func_233580_cy_(), 1);
                    boolean bl = shearingSuccessful = !items.isEmpty();
                    if (shearingSuccessful && !player.field_71075_bZ.field_75098_d) {
                        heldItem.func_222118_a(1, (LivingEntity)player, p -> p.func_213361_c(player.func_184614_ca().getEquipmentSlot()));
                    }
                    items.forEach(itemStack -> {
                        ItemEntity itemEntity = new ItemEntity((World)level, sheep2.func_226277_ct_(), sheep2.func_226283_e_(1.0), sheep2.func_226281_cx_(), itemStack);
                        level.func_217376_c((Entity)itemEntity);
                    });
                    if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                    }
                }
                if (shearingSuccessful) {
                    PROCESSED_ENTITY_IDS.add(sheep2.func_145782_y());
                    ++shearedCount;
                    if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86\u7f8a {}", (Object)sheep2.func_145782_y());
                    }
                    if (!heldItem.func_190926_b()) continue;
                    break;
                }
                if (!((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) continue;
                Onekeyminer.LOGGER.debug("\u526a\u7f8a {} \u5931\u8d25\uff0c\u5c3d\u7ba1\u5b83\u5e94\u8be5\u662f\u53ef\u526a\u7684", (Object)sheep2.func_145782_y());
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406\u7f8a {} \u65f6\u51fa\u9519: {}", (Object)sheep2.func_145782_y(), (Object)e.getMessage());
            }
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86 {} \u53ea\u7f8a", (Object)shearedCount);
        }
        if (shearedCount > 1 && ((Boolean)ClientConfig.INSTANCE.showBlockCount.get()).booleanValue()) {
            String messageStyle = (String)ClientConfig.INSTANCE.messageStyle.get();
            if (messageStyle.equals("chat") || messageStyle.equals("both")) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.onekeyminer.chain_shearing", new Object[]{shearedCount}), player.func_110124_au());
            }
            if (messageStyle.equals("actionbar") || messageStyle.equals("both")) {
                NetworkHandler.sendToPlayer(new ChainActionPacket("shearing", shearedCount), player);
            }
            return true;
        }
        return shearedCount > 1;
    }

    private static class BlockSearchNode {
        final BlockPos pos;
        final int depth;

        BlockSearchNode(BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }
    }
}

