/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FungusBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.NetherSproutsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class PlantingHandler {
    private static final Set<BlockPos> CURRENTLY_PLANTING = new HashSet<BlockPos>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        ItemStack heldItem = player.func_184586_b(event.getHand());
        if (!PlantingHandler.isPlantableItem(heldItem)) {
            return;
        }
        if (PlantingHandler.isInBlacklist(heldItem)) {
            return;
        }
        BlockPos pos = event.getPos();
        if (CURRENTLY_PLANTING.contains(pos)) {
            return;
        }
        CURRENTLY_PLANTING.add(pos);
        try {
            serverPlayer.field_70170_p.func_73046_m().execute(() -> {
                World level = serverPlayer.field_70170_p;
                BlockState targetState = level.func_180495_p(pos);
                PlantingHandler.performChainPlanting(serverPlayer, event.getHand(), pos, targetState, heldItem);
            });
        }
        finally {
            CURRENTLY_PLANTING.remove(pos);
        }
    }

    private static void performChainPlanting(ServerPlayerEntity player, Hand hand, BlockPos startPos, BlockState targetState, ItemStack seedItem) {
        World level = player.field_70170_p;
        if (!(level instanceof ServerWorld)) {
            return;
        }
        int maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        if (player.func_184812_l_()) {
            maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get();
        }
        long startTime = System.currentTimeMillis();
        long timeLimit = 2000L;
        int maxIterations = Math.min(10000, maxPlants * 10);
        int iterations = 0;
        int availableSeeds = PlantingHandler.countAvailableItems((PlayerEntity)player, seedItem.func_77973_b());
        if (player.func_184812_l_()) {
            availableSeeds = Integer.MAX_VALUE;
        }
        LinkedList<BlockPos> positionsToCheck = new LinkedList<BlockPos>();
        positionsToCheck.add(startPos);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        checkedPositions.add(startPos);
        HashSet<BlockPos> plantedPositions = new HashSet<BlockPos>();
        boolean allowDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int plantsCount = 0;
        try {
            while (!positionsToCheck.isEmpty() && plantsCount < maxPlants && iterations < maxIterations && System.currentTimeMillis() - startTime <= 2000L) {
                ++iterations;
                BlockPos currentPos = (BlockPos)positionsToCheck.poll();
                if (plantedPositions.contains(currentPos)) continue;
                if (plantsCount >= availableSeeds && !player.func_184812_l_()) break;
                if (PlantingHandler.canPlantAt(level, currentPos, level.func_180495_p(currentPos), seedItem)) {
                    try {
                        if (PlantingHandler.tryPlant(player, hand, currentPos, seedItem)) {
                            plantedPositions.add(currentPos);
                            ++plantsCount;
                            if (!player.func_184812_l_()) {
                                --availableSeeds;
                            }
                        }
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u5728\u4f4d\u7f6e {} \u79cd\u690d\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)currentPos, (Object)e.getMessage());
                    }
                }
                for (Direction direction : Direction.values()) {
                    try {
                        BlockPos adjacentPos = currentPos.func_177972_a(direction);
                        if (checkedPositions.contains(adjacentPos) || !(adjacentPos.func_177951_i((Vector3i)startPos) <= 100.0)) continue;
                        positionsToCheck.add(adjacentPos);
                        checkedPositions.add(adjacentPos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (allowDiagonal && iterations % 2 == 0) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                try {
                                    BlockPos diagonalPos = currentPos.func_177982_a(x, y, z);
                                    if (checkedPositions.contains(diagonalPos) || !(diagonalPos.func_177951_i((Vector3i)startPos) <= 100.0)) continue;
                                    positionsToCheck.add(diagonalPos);
                                    checkedPositions.add(diagonalPos);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (positionsToCheck.size() <= 1000) continue;
                LinkedList limitedQueue = new LinkedList();
                for (int i = 0; i < 500 && !positionsToCheck.isEmpty(); ++i) {
                    limitedQueue.add(positionsToCheck.poll());
                }
                positionsToCheck = limitedQueue;
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8fde\u9501\u79cd\u690d\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u9884\u671f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        if (plantsCount > 0) {
            try {
                NetworkHandler.sendToPlayer(new ChainActionPacket("planting", plantsCount), player);
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u53d1\u9001\u8fde\u9501\u79cd\u690d\u6d88\u606f\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static boolean tryPlant(ServerPlayerEntity player, Hand hand, BlockPos pos, ItemStack seedItem) {
        World level = player.field_70170_p;
        BlockRayTraceResult hitResult = new BlockRayTraceResult(Vector3d.func_237489_a_((Vector3i)pos), Direction.UP, pos, false);
        ItemUseContext context = new ItemUseContext((PlayerEntity)player, hand, hitResult);
        ActionResultType result = seedItem.func_196084_a(context);
        return result.func_226246_a_();
    }

    private static boolean canPlantAt(World level, BlockPos pos, BlockState state, ItemStack seedItem) {
        if (!level.func_175623_d(pos)) {
            return false;
        }
        BlockPos belowPos = pos.func_177977_b();
        BlockState belowState = level.func_180495_p(belowPos);
        return PlantingHandler.canPlantOnSurface(seedItem.func_77973_b(), belowState);
    }

    private static int countAvailableItems(PlayerEntity player, Item item) {
        int count = 0;
        if (player.func_184614_ca().func_77973_b() == item) {
            count += player.func_184614_ca().func_190916_E();
        }
        if (player.func_184592_cb().func_77973_b() == item) {
            count += player.func_184592_cb().func_190916_E();
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private static boolean canPlantOnSurface(Item item, BlockState surfaceState) {
        Block surfaceBlock = surfaceState.func_177230_c();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.func_179223_d();
            if (block instanceof CropsBlock) {
                return surfaceBlock == Blocks.field_150458_ak;
            }
            if (block instanceof SaplingBlock || block instanceof FlowerBlock) {
                return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_196658_i || surfaceBlock == Blocks.field_196661_l || surfaceBlock == Blocks.field_150391_bh;
            }
            if (block instanceof MushroomBlock) {
                return surfaceBlock == Blocks.field_150391_bh;
            }
            if (item == Items.field_151174_bG || item == Items.field_151172_bF || item == Items.field_151014_N || item == Items.field_185163_cU) {
                return surfaceBlock == Blocks.field_150458_ak;
            }
        }
        return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_196658_i || surfaceBlock == Blocks.field_196661_l || surfaceBlock == Blocks.field_150354_m || surfaceBlock == Blocks.field_150425_aM || surfaceBlock == Blocks.field_150391_bh || surfaceBlock instanceof FarmlandBlock || surfaceBlock == Blocks.field_150458_ak || CommonConfig.INSTANCE.isFarmlandAllowedForChainPlanting(surfaceBlock.func_176223_P());
    }

    static boolean isPlantableItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (PlantingHandler.isInBlacklist(stack)) {
            return false;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.func_179223_d();
            ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            return block instanceof CropsBlock || block instanceof SaplingBlock || block instanceof BushBlock || block instanceof FlowerBlock || block instanceof TallFlowerBlock || block instanceof CactusBlock || block instanceof TallGrassBlock || block instanceof FungusBlock || block instanceof NetherSproutsBlock || block instanceof CocoaBlock || block instanceof SugarCaneBlock || block instanceof NetherWartBlock;
        }
        String itemName = item.toString().toLowerCase();
        if (itemName.contains("seed") || itemName.contains("sapling") || itemName.contains("seedling") || itemName.contains("plant")) {
            return true;
        }
        return item == Items.field_151014_N || item == Items.field_185163_cU || item == Items.field_151080_bb || item == Items.field_151081_bc || item == Items.field_151174_bG || item == Items.field_151172_bF || item == Items.field_222112_pR || item == Items.field_234722_bw_ || item == Items.field_234723_bx_ || item == Items.field_196130_bo || item == Items.field_222066_kO || item == Items.field_222068_kQ || item == Items.field_222065_kN || item == Items.field_221774_cw || item == Items.field_221601_aC;
    }

    private static boolean isInBlacklist(ItemStack stack) {
        return CommonConfig.INSTANCE.isSeedBlacklisted(stack.func_77973_b());
    }

    private static boolean isPlantableBlock(Block block) {
        return block == Blocks.field_196674_t || block == Blocks.field_196675_u || block == Blocks.field_196676_v || block == Blocks.field_196678_w || block == Blocks.field_196679_x || block == Blocks.field_196680_y;
    }

    public static List<BlockPos> computePlantingPositions(ServerPlayerEntity player, ServerWorld level, BlockPos startPos, BlockState targetState, ItemStack seedItem) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (!PlantingHandler.isPlantableItem(seedItem)) {
            return result;
        }
        int maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        if (player.func_184812_l_()) {
            maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get();
        }
        long startTime = System.currentTimeMillis();
        long timeLimit = 500L;
        int maxIterations = Math.min(5000, maxPlants * 8);
        int iterations = 0;
        int availableSeeds = PlantingHandler.countAvailableItems((PlayerEntity)player, seedItem.func_77973_b());
        if (player.func_184812_l_()) {
            availableSeeds = Integer.MAX_VALUE;
        }
        LinkedList<BlockPos> positionsToCheck = new LinkedList<BlockPos>();
        positionsToCheck.add(startPos);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        checkedPositions.add(startPos);
        boolean allowDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int plantsCount = 0;
        try {
            while (!positionsToCheck.isEmpty() && plantsCount < maxPlants && iterations < maxIterations && plantsCount < availableSeeds && System.currentTimeMillis() - startTime <= 500L) {
                ++iterations;
                BlockPos currentPos = (BlockPos)positionsToCheck.poll();
                if (PlantingHandler.canPlantAt((World)level, currentPos, level.func_180495_p(currentPos), seedItem)) {
                    result.add(currentPos);
                    ++plantsCount;
                }
                for (Direction direction : Direction.values()) {
                    BlockPos adjacentPos = currentPos.func_177972_a(direction);
                    if (checkedPositions.contains(adjacentPos) || !(adjacentPos.func_177951_i((Vector3i)startPos) <= 100.0)) continue;
                    positionsToCheck.add(adjacentPos);
                    checkedPositions.add(adjacentPos);
                }
                if (allowDiagonal && iterations % 2 == 0) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                BlockPos diagonalPos = currentPos.func_177982_a(x, y, z);
                                if (checkedPositions.contains(diagonalPos) || !(diagonalPos.func_177951_i((Vector3i)startPos) <= 100.0)) continue;
                                positionsToCheck.add(diagonalPos);
                                checkedPositions.add(diagonalPos);
                            }
                        }
                    }
                }
                if (positionsToCheck.size() <= 500) continue;
                LinkedList limitedQueue = new LinkedList();
                for (int i = 0; i < 250 && !positionsToCheck.isEmpty(); ++i) {
                    limitedQueue.add(positionsToCheck.poll());
                }
                positionsToCheck = limitedQueue;
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u79cd\u690d\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleChainPlanting(ServerPlayerEntity player, PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        Hand hand = event.getHand();
        ItemStack heldItem = player.func_184586_b(hand);
        boolean canProcess = false;
        Set<BlockPos> set = CURRENTLY_PLANTING;
        synchronized (set) {
            if (!CURRENTLY_PLANTING.contains(pos)) {
                CURRENTLY_PLANTING.add(pos);
                canProcess = true;
            }
        }
        if (!canProcess) {
            return;
        }
        try {
            player.field_70170_p.func_73046_m().func_222817_e(() -> {
                Object level;
                try {
                    level = player.field_70170_p;
                    BlockState targetState = level.func_180495_p(pos);
                    PlantingHandler.performChainPlanting(player, hand, pos, targetState, heldItem);
                }
                catch (Throwable e) {
                    Onekeyminer.LOGGER.error("\u8fde\u9501\u79cd\u690d\u6267\u884c\u671f\u95f4\u53d1\u751f\u4e25\u91cd\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    level = CURRENTLY_PLANTING;
                    synchronized (level) {
                        CURRENTLY_PLANTING.remove(pos);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Onekeyminer.LOGGER.error("\u65e0\u6cd5\u63d0\u4ea4\u4efb\u52a1: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

