/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;

@Mod.EventBusSubscriber(modid="onekeyminer")
public class UnifiedChainHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        try {
            if (!ChainModeCapability.isChainModeActive(player)) {
                return;
            }
            if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.func_225608_bj_()) {
                return;
            }
            if (player.func_184812_l_() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
                return;
            }
            if (!UnifiedChainHandler.isToolItem(player.func_184586_b(event.getHand()))) {
                return;
            }
            ItemStack heldItem = player.func_184586_b(event.getHand());
            BlockState targetState = event.getWorld().func_180495_p(event.getPos());
            try {
                UUID uuid = player.func_110124_au();
                String key = uuid.toString();
                if (InteractionHandler.isValidInteractionTool(heldItem)) {
                    ChainPositionStore.setInteractionPositions(key, new ArrayList<BlockPos>());
                } else if (UnifiedChainHandler.isPlantableItem(heldItem)) {
                    ChainPositionStore.setPlantingPositions(key, new ArrayList<BlockPos>());
                } else {
                    ChainPositionStore.setMiningPositions(key, new ArrayList<BlockPos>());
                }
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.debug("\u6e05\u7406\u8fde\u9501\u4f4d\u7f6e\u5b58\u50a8\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            }
            if (InteractionHandler.isValidInteractionTool(heldItem)) {
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u89e6\u53d1\u5de5\u5177\u8fde\u9501\u4ea4\u4e92: {}", (Object)heldItem.func_77973_b().getClass().getSimpleName());
                }
                InteractionHandler.tryChainInteraction(player, (ServerWorld)event.getWorld(), event.getPos(), event.getFace(), event.getHitVec().func_216347_e(), event.getHand());
            } else if (UnifiedChainHandler.isPlantableItem(heldItem)) {
                PlantingHandler.handleChainPlanting(player, event);
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u73a9\u5bb6\u4ea4\u4e92\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        try {
            SheepEntity sheep;
            if (!ChainModeCapability.isChainModeActive(player)) {
                return;
            }
            if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.func_225608_bj_()) {
                return;
            }
            if (player.func_184812_l_() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
                return;
            }
            ItemStack heldItem = player.func_184586_b(event.getHand());
            Entity targetEntity = event.getTarget();
            if (heldItem.func_77973_b() instanceof ShearsItem && targetEntity instanceof SheepEntity && (sheep = (SheepEntity)targetEntity).func_230262_K__()) {
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u68c0\u6d4b\u5230\u526a\u7f8a\u6bdb\u64cd\u4f5c");
                }
                MinecraftServer server = player.field_70170_p.func_73046_m();
                server.execute(() -> InteractionHandler.tryChainShearing(player, sheep, event.getHand()));
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u5b9e\u4f53\u4ea4\u4e92\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        try {
            if (!ChainModeCapability.isChainModeActive(player)) {
                return;
            }
            ItemStack tool = player.func_184614_ca();
            BlockState state = event.getState();
            World level = player.field_70170_p;
            ServerWorld serverLevel = (ServerWorld)level;
            TileEntity blockEntity = level.func_175625_s(event.getPos());
            ChainHandler.tryChainMine(player, event.getPos(), state, tool);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u65b9\u5757\u7834\u574f\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    public static boolean isToolItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ShearsItem || item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || UnifiedChainHandler.isPlantableItem(stack);
    }

    public static boolean isPlantableItem(ItemStack stack) {
        return PlantingHandler.isPlantableItem(stack);
    }
}

