/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.client;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.client.ClientUtils;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.ChainModePacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

@Mod.EventBusSubscriber(modid="onekeyminer", value={Dist.CLIENT})
public class KeyBindings {
    public static final KeyBinding CHAIN_KEY = new KeyBinding("key.onekeyminer.chain", 96, "key.categories.onekeyminer");
    private static boolean chainModeActive = false;
    private static int packetCounter = 0;
    private static int frozenTimerCounter = 0;
    private static long lastCheckTime = 0L;
    private static Timer timer = null;

    @SubscribeEvent
    public static void registerKeyMappings(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)CHAIN_KEY);
    }

    public static void registerClientTick() {
        if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
            Onekeyminer.LOGGER.info("\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u5b9a\u65f6\u5668");
        }
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer("ChainModeTimer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                KeyBindings.handleTimerTick();
            }
        }, 0L, 100L);
        lastCheckTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (CHAIN_KEY.func_151468_f()) {
            Boolean requireKeyHold = (Boolean)ClientConfig.INSTANCE.requireKeyHold.get();
            if (requireKeyHold == null) {
                if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
                    Onekeyminer.LOGGER.error("\u914d\u7f6e\u9879 requireKeyHold \u672a\u6b63\u786e\u521d\u59cb\u5316\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c false");
                }
                requireKeyHold = false;
            }
            if (requireKeyHold.booleanValue()) {
                chainModeActive = true;
                NetworkHandler.sendToServer(new ChainModePacket(true));
                packetCounter = 0;
                if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("Key pressed, activating chain mode (hold mode)");
                }
            } else {
                chainModeActive = !chainModeActive;
                NetworkHandler.sendToServer(new ChainModePacket(chainModeActive));
                if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("Key pressed, toggling chain mode: {}", (Object)chainModeActive);
                }
                if (chainModeActive) {
                    frozenTimerCounter = (Integer)ClientConfig.INSTANCE.frozentimer.get() * 1000;
                }
                ClientUtils.showStatusMessage(chainModeActive ? "message.onekeyminer.mode_enabled" : "message.onekeyminer.mode_disabled");
            }
            if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("Client chain mode state after key press: {}", (Object)chainModeActive);
            }
        }
    }

    public static void handleTimerTick() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null || minecraft.field_71439_g == null || minecraft.field_71441_e == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastCheckTime;
        lastCheckTime = currentTime;
        if (elapsed <= 0L || elapsed > 5000L) {
            return;
        }
        if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
            if (CHAIN_KEY.func_151470_d()) {
                if ((packetCounter = (int)((long)packetCounter + elapsed)) >= 500) {
                    minecraft.execute(() -> NetworkHandler.sendToServer(new ChainModePacket(true)));
                    packetCounter = 0;
                }
            } else if (chainModeActive) {
                chainModeActive = false;
                minecraft.execute(() -> NetworkHandler.sendToServer(new ChainModePacket(false)));
            }
        } else if (chainModeActive && frozenTimerCounter > 0 && (frozenTimerCounter = (int)((long)frozenTimerCounter - elapsed)) <= 0) {
            chainModeActive = false;
            minecraft.execute(() -> {
                NetworkHandler.sendToServer(new ChainModePacket(false));
                ClientUtils.showStatusMessage("message.onekeyminer.mode_disabled");
            });
        }
    }
}

