/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ConfigUtils;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

@Mod.EventBusSubscriber(modid="onekeyminer")
public class ModCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"excavation").then(Commands.func_197057_a((String)"status").executes(ModCommands::showStatus))).then(Commands.func_197057_a((String)"help").executes(ModCommands::showHelp))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"common").requires(source -> source.func_197034_c(2))).then(ModCommands.registerCommonConfigCommands()))).then(Commands.func_197057_a((String)"client").then(ModCommands.registerClientConfigCommands()))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"server").requires(source -> source.func_197034_c(4))).then(ModCommands.registerServerConfigCommands()))).executes(ModCommands::showHelp));
    }

    private static int showHelp(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.help.title"), false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.help.status"), false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.help.server"), false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.help.client"), false);
        return 1;
    }

    private static int showStatus(CommandContext<CommandSource> context) {
        if (((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f();
            boolean chainActive = ChainModeCapability.isChainModeActive(player);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.status", new Object[]{new TranslationTextComponent(chainActive ? "command.onekeyminer.status.on" : "command.onekeyminer.status.off")}), false);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.status.maxblocks", new Object[]{CommonConfig.INSTANCE.maxBlocksInChain.get()}), false);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.status.maxdepth", new Object[]{CommonConfig.INSTANCE.maxChainDepth.get()}), false);
            boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.status.diagonal", new Object[]{new TranslationTextComponent(diagonal ? "command.onekeyminer.enabled" : "command.onekeyminer.disabled")}), false);
            boolean requireSneaking = (Boolean)CommonConfig.INSTANCE.requireSneaking.get();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.status.sneaking", new Object[]{new TranslationTextComponent(requireSneaking ? "command.onekeyminer.required" : "command.onekeyminer.not_required")}), false);
            return 1;
        }
        return 0;
    }

    private static LiteralArgumentBuilder<CommandSource> registerCommonConfigCommands() {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"options");
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"maxChainBlocks").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSource>)ctx, "maxChainBlocks", CommonConfig.INSTANCE.maxChainBlocks.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4096)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSource>)ctx, "maxChainBlocks", CommonConfig.INSTANCE.maxChainBlocks, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"maxChainDepth").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSource>)ctx, "maxChainDepth", CommonConfig.INSTANCE.maxChainDepth.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSource>)ctx, "maxChainDepth", CommonConfig.INSTANCE.maxChainDepth, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"maxBlocksInChain").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSource>)ctx, "maxBlocksInChain", CommonConfig.INSTANCE.maxBlocksInChain.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4096)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSource>)ctx, "maxBlocksInChain", CommonConfig.INSTANCE.maxBlocksInChain, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"maxBlocksInChainCreative").executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSource>)ctx, "maxBlocksInChainCreative", CommonConfig.INSTANCE.maxBlocksInChainCreative.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSource>)ctx, "maxBlocksInChainCreative", CommonConfig.INSTANCE.maxBlocksInChainCreative, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"nonChainableBlocks").then(Commands.func_197057_a((String)"list").executes(ModCommands::listNonChainableBlocks))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"blockId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.addToNonChainableBlocks((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"blockId")))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"blockId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.removeFromNonChainableBlocks((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"blockId"))))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"seedBlacklist").then(Commands.func_197057_a((String)"list").executes(ModCommands::listSeedBlacklist))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"seedId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.addToSeedBlacklist((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"seedId")))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"seedId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ModCommands.removeFromSeedBlacklist((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"seedId"))))));
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "enableDiagonalChaining", CommonConfig.INSTANCE.enableDiagonalChaining);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "teleportDropsToPlayer", CommonConfig.INSTANCE.teleportDropsToPlayer);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "ignoreToolCompatibility", CommonConfig.INSTANCE.ignoreToolCompatibility);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "matchBlockState", CommonConfig.INSTANCE.matchBlockState);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "matchSeedBlockState", CommonConfig.INSTANCE.matchseedBlockState);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "enableInCreative", CommonConfig.INSTANCE.enableInCreative);
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "requireSneaking", CommonConfig.INSTANCE.requireSneaking);
        return builder;
    }

    private static void addBooleanConfigOption(LiteralArgumentBuilder<CommandSource> builder, String optionName, ForgeConfigSpec.BooleanValue configValue) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)optionName).executes(ctx -> ModCommands.showCommonConfigValue((CommandContext<CommandSource>)ctx, optionName, configValue.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ModCommands.setCommonConfigBoolValue((CommandContext<CommandSource>)ctx, optionName, configValue, BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))));
    }

    private static int showCommonConfigValue(CommandContext<CommandSource> context, String name, Object value) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.value", new Object[]{name, value}), player.func_110124_au());
        return 1;
    }

    private static int setCommonConfigIntValue(CommandContext<CommandSource> context, String name, ForgeConfigSpec.IntValue configValue, int newValue) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        configValue.set((Object)newValue);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.set.int", new Object[]{name, newValue}), player.func_110124_au());
        return 1;
    }

    private static int setCommonConfigBoolValue(CommandContext<CommandSource> context, String name, ForgeConfigSpec.BooleanValue configValue, boolean newValue) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        configValue.set((Object)newValue);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        String status = newValue ? new TranslationTextComponent("command.onekeyminer.enabled").getString() : new TranslationTextComponent("command.onekeyminer.disabled").getString();
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.set.bool", new Object[]{name, status}), player.func_110124_au());
        return 1;
    }

    private static int listNonChainableBlocks(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        List blocks = (List)CommonConfig.INSTANCE.nonChainableBlocks.get();
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.blacklist.blocks.title"), player.func_110124_au());
        if (blocks.isEmpty()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.list.empty"), player.func_110124_au());
        } else {
            for (String block : blocks) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.list.item", new Object[]{block}), player.func_110124_au());
            }
        }
        return 1;
    }

    private static int addToNonChainableBlocks(CommandContext<CommandSource> context, String blockId) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ArrayList<String> blocks = new ArrayList<String>((Collection)CommonConfig.INSTANCE.nonChainableBlocks.get());
        if (!blockId.contains(":")) {
            blockId = "minecraft:" + blockId;
        }
        if (blocks.contains(blockId)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.blacklist.block.exists", new Object[]{blockId}), player.func_110124_au());
            return 0;
        }
        blocks.add(blockId);
        CommonConfig.INSTANCE.nonChainableBlocks.set(blocks);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.blacklist.block.added", new Object[]{blockId}), player.func_110124_au());
        return 1;
    }

    private static int removeFromNonChainableBlocks(CommandContext<CommandSource> context, String blockId) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ArrayList blocks = new ArrayList((Collection)CommonConfig.INSTANCE.nonChainableBlocks.get());
        if (!blockId.contains(":")) {
            blockId = "minecraft:" + blockId;
        }
        if (!blocks.contains(blockId)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.blacklist.block.not_exists", new Object[]{blockId}), player.func_110124_au());
            return 0;
        }
        blocks.remove(blockId);
        CommonConfig.INSTANCE.nonChainableBlocks.set(blocks);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.blacklist.block.removed", new Object[]{blockId}), player.func_110124_au());
        return 1;
    }

    private static int listSeedBlacklist(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        List seeds = (List)CommonConfig.INSTANCE.seedBlacklist.get();
        player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7e\u4e0d\u53ef\u8fde\u9501\u79cd\u690d\u7684\u79cd\u5b50\u5217\u8868\uff1a"), player.func_110124_au());
        if (seeds.isEmpty()) {
            player.func_145747_a((ITextComponent)new StringTextComponent("  \u00a77(\u5217\u8868\u4e3a\u7a7a)"), player.func_110124_au());
        } else {
            for (String seed : seeds) {
                player.func_145747_a((ITextComponent)new StringTextComponent("  \u00a77- \u00a7r" + seed), player.func_110124_au());
            }
        }
        return 1;
    }

    private static int addToSeedBlacklist(CommandContext<CommandSource> context, String seedId) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ArrayList<String> seeds = new ArrayList<String>((Collection)CommonConfig.INSTANCE.seedBlacklist.get());
        if (!seedId.contains(":")) {
            seedId = "minecraft:" + seedId;
        }
        if (seeds.contains(seedId)) {
            player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7c\u79cd\u5b50 " + seedId + " \u5df2\u5728\u9ed1\u540d\u5355\u4e2d"), player.func_110124_au());
            return 0;
        }
        seeds.add(seedId);
        CommonConfig.INSTANCE.seedBlacklist.set(seeds);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7a\u5df2\u5c06 " + seedId + " \u6dfb\u52a0\u5230\u4e0d\u53ef\u8fde\u9501\u79cd\u690d\u5217\u8868"), player.func_110124_au());
        return 1;
    }

    private static int removeFromSeedBlacklist(CommandContext<CommandSource> context, String seedId) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ArrayList seeds = new ArrayList((Collection)CommonConfig.INSTANCE.seedBlacklist.get());
        if (!seedId.contains(":")) {
            seedId = "minecraft:" + seedId;
        }
        if (!seeds.contains(seedId)) {
            player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7c\u79cd\u5b50 " + seedId + " \u4e0d\u5728\u9ed1\u540d\u5355\u4e2d"), player.func_110124_au());
            return 0;
        }
        seeds.remove(seedId);
        CommonConfig.INSTANCE.seedBlacklist.set(seeds);
        ConfigUtils.saveConfig(CommonConfig.SPEC);
        player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7a\u5df2\u4ece\u4e0d\u53ef\u8fde\u9501\u79cd\u690d\u5217\u8868\u4e2d\u79fb\u9664 " + seedId), player.func_110124_au());
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSource> registerClientConfigCommands() {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"options");
        ModCommands.addBooleanConfigOption((LiteralArgumentBuilder<CommandSource>)builder, "showBlockCount", ClientConfig.INSTANCE.showBlockCount);
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"messageStyle").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSource>)ctx, "messageStyle", ClientConfig.INSTANCE.messageStyle.get()))).then(Commands.func_197056_a((String)"style", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionBuilder) -> {
            for (String style : Arrays.asList("chat", "actionbar", "both", "none")) {
                if (!style.startsWith(suggestionBuilder.getRemaining().toLowerCase())) continue;
                suggestionBuilder.suggest(style);
            }
            return suggestionBuilder.buildFuture();
        }).executes(ctx -> {
            String style = StringArgumentType.getString((CommandContext)ctx, (String)"style");
            if (Arrays.asList("chat", "actionbar", "both", "none").contains(style)) {
                ClientConfig.INSTANCE.messageStyle.set((Object)style);
                ConfigUtils.saveConfig(ClientConfig.SPEC);
                ServerPlayerEntity _p = ((CommandSource)ctx.getSource()).func_197035_h();
                _p.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.messagestyle.set", new Object[]{style}), _p.func_110124_au());
                return 1;
            }
            ServerPlayerEntity _p = ((CommandSource)ctx.getSource()).func_197035_h();
            _p.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.invalid_option"), _p.func_110124_au());
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"keyMode").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSource>)ctx, "keyMode", ClientConfig.INSTANCE.requireKeyHold.get()))).then(Commands.func_197056_a((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionBuilder) -> {
            for (String mode : Arrays.asList("toggle", "hold")) {
                if (!mode.startsWith(suggestionBuilder.getRemaining().toLowerCase())) continue;
                suggestionBuilder.suggest(mode);
            }
            return suggestionBuilder.buildFuture();
        }).executes(ctx -> {
            String mode = StringArgumentType.getString((CommandContext)ctx, (String)"mode");
            if (Arrays.asList("toggle", "hold").contains(mode)) {
                ClientConfig.INSTANCE.requireKeyHold.set((Object)mode.equals("hold"));
                ConfigUtils.saveConfig(ClientConfig.SPEC);
                ServerPlayerEntity _p = ((CommandSource)ctx.getSource()).func_197035_h();
                _p.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.keyhold.set", new Object[]{mode}), _p.func_110124_au());
                return 1;
            }
            ServerPlayerEntity _p = ((CommandSource)ctx.getSource()).func_197035_h();
            _p.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.invalid_option"), _p.func_110124_au());
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"Debug").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSource>)ctx, "Debug", ClientConfig.INSTANCE.Debug.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ModCommands.setCommonConfigBoolValue((CommandContext<CommandSource>)ctx, "Debug", ClientConfig.INSTANCE.Debug, BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"frozen timer").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSource>)ctx, "frozen timer", ClientConfig.INSTANCE.frozentimer.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Short.MAX_VALUE)).executes(ctx -> ModCommands.setCommonConfigIntValue((CommandContext<CommandSource>)ctx, "frozen timer", ClientConfig.INSTANCE.frozentimer, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSource> registerServerConfigCommands() {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"options");
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"toolDurabilityThreshold").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSource>)ctx, "toolDurabilityThreshold", ServerConfig.INSTANCE.toolDurabilityThreshold.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1000.0)).executes(ctx -> {
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            ServerConfig.INSTANCE.toolDurabilityThreshold.set((Object)value);
            ConfigUtils.saveConfig(ServerConfig.SPEC);
            ServerPlayerEntity _p = ((CommandSource)ctx.getSource()).func_197035_h();
            _p.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.tool_durability.set", new Object[]{value}), _p.func_110124_au());
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hungerThreshold").executes(ctx -> ModCommands.showConfigValue((CommandContext<CommandSource>)ctx, "hungerThreshold", ServerConfig.INSTANCE.hungerThreshold.get()))).then(Commands.func_197056_a((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)20.0)).executes(ctx -> {
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            ServerConfig.INSTANCE.hungerThreshold.set((Object)value);
            ConfigUtils.saveConfig(ServerConfig.SPEC);
            ServerPlayerEntity _p = ((CommandSource)ctx.getSource()).func_197035_h();
            _p.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.hunger.set", new Object[]{value}), _p.func_110124_au());
            return 1;
        })));
        return builder;
    }

    private static int showConfigValue(CommandContext<CommandSource> context, String name, Object value) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.onekeyminer.config.value", new Object[]{name, value}), player.func_110124_au());
        return 1;
    }
}

