/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import org.xiyu.yee.onekeyminer.client.ClientUtils;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class BlocksMinedPacket
implements IOneKeyPacket {
    private final int blockCount;

    public BlocksMinedPacket(int blockCount) {
        this.blockCount = blockCount;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public static BlocksMinedPacket fromNetwork(PacketBuffer buf) {
        return new BlocksMinedPacket(buf.readInt());
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeInt(this.blockCount);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.BLOCKS_MINED_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.BLOCKS_MINED_TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(BlocksMinedPacket packet, NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71439_g != null && ((Boolean)ClientConfig.INSTANCE.showBlockCount.get()).booleanValue()) {
                ClientUtils.showBlockCountMessage(packet.blockCount);
            }
        });
        context.setPacketHandled(true);
    }
}

