/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainAPI;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.network.ChainPositionsPacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainModePacket
implements IOneKeyPacket {
    private final boolean active;

    public ChainModePacket(boolean active) {
        this.active = active;
    }

    public static ChainModePacket fromNetwork(PacketBuffer buf) {
        return new ChainModePacket(buf.readBoolean());
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeBoolean(this.active);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_MODE_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.CHAIN_MODE_TYPE;
    }

    public static void handleOnServer(ChainModePacket packet, NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayerEntity serverPlayer = context.getSender();
            ChainModeCapability.setChainMode(serverPlayer, packet.active);
            try {
                String key = serverPlayer.func_110124_au().toString();
                if (packet.active) {
                    RayTraceResult hr = serverPlayer.func_213324_a(6.0, 0.0f, false);
                    if (hr != null && hr.func_216346_c() == RayTraceResult.Type.BLOCK) {
                        BlockRayTraceResult bhr = (BlockRayTraceResult)hr;
                        BlockPos pos = bhr.func_216350_a();
                        BlockState state = serverPlayer.field_70170_p.func_180495_p(pos);
                        ItemStack held = serverPlayer.func_184586_b(Hand.MAIN_HAND);
                        List<BlockPos> mining = ChainAPI.computeMiningPositions(serverPlayer, (ServerWorld)serverPlayer.field_70170_p, pos, state, held);
                        ChainPositionStore.setMiningPositions(key, mining);
                        List<BlockPos> interaction = ChainAPI.computeInteractionPositions(serverPlayer, (ServerWorld)serverPlayer.field_70170_p, pos, state, Hand.MAIN_HAND);
                        ChainPositionStore.setInteractionPositions(key, interaction);
                        List<BlockPos> planting = ChainAPI.computePlantingPositions(serverPlayer, (ServerWorld)serverPlayer.field_70170_p, pos, state, held);
                        ChainPositionStore.setPlantingPositions(key, planting);
                        ChainPositionsPacket sync = new ChainPositionsPacket(key, true, mining, interaction, planting);
                        NetworkHandler.sendToPlayer(sync, serverPlayer);
                    }
                } else {
                    ChainPositionStore.clearAll(key);
                    ChainPositionsPacket sync = new ChainPositionsPacket(key, false, null, null, null);
                    NetworkHandler.sendToPlayer(sync, serverPlayer);
                }
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406 ChainModePacket \u65f6\u8ba1\u7b97 positions \u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(ChainModePacket packet, NetworkEvent.Context context) {
        Minecraft minecraft = Minecraft.func_71410_x();
        context.enqueueWork(() -> {
            if (minecraft.field_71439_g == null) {
                return;
            }
            minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent(packet.active ? "message.onekeyminer.chain_mode_on" : "message.onekeyminer.chain_mode_off"), true);
        });
        context.setPacketHandled(true);
    }
}

