/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainPositionsPacket
implements IOneKeyPacket {
    private final String playerUuid;
    private final boolean active;
    private final List<BlockPos> mining;
    private final List<BlockPos> interaction;
    private final List<BlockPos> planting;

    public ChainPositionsPacket(String playerUuid, boolean active, List<BlockPos> mining, List<BlockPos> interaction, List<BlockPos> planting) {
        this.playerUuid = playerUuid;
        this.active = active;
        this.mining = mining == null ? new ArrayList() : mining;
        this.interaction = interaction == null ? new ArrayList() : interaction;
        this.planting = planting == null ? new ArrayList() : planting;
    }

    public static ChainPositionsPacket fromNetwork(PacketBuffer buf) {
        String uuid = buf.func_218666_n();
        boolean active = buf.readBoolean();
        int m = buf.readInt();
        ArrayList<BlockPos> mining = new ArrayList<BlockPos>();
        for (int i = 0; i < m; ++i) {
            mining.add(buf.func_179259_c());
        }
        int it = buf.readInt();
        ArrayList<BlockPos> interaction = new ArrayList<BlockPos>();
        for (int i = 0; i < it; ++i) {
            interaction.add(buf.func_179259_c());
        }
        int p = buf.readInt();
        ArrayList<BlockPos> planting = new ArrayList<BlockPos>();
        for (int i = 0; i < p; ++i) {
            planting.add(buf.func_179259_c());
        }
        return new ChainPositionsPacket(uuid, active, mining, interaction, planting);
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.playerUuid);
        buf.writeBoolean(this.active);
        buf.writeInt(this.mining.size());
        for (BlockPos b : this.mining) {
            buf.func_179255_a(b);
        }
        buf.writeInt(this.interaction.size());
        for (BlockPos b : this.interaction) {
            buf.func_179255_a(b);
        }
        buf.writeInt(this.planting.size());
        for (BlockPos b : this.planting) {
            buf.func_179255_a(b);
        }
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_POSITIONS_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.CHAIN_POSITIONS_TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(ChainPositionsPacket packet, NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            try {
                ChainPositionStore.setChainMode(packet.playerUuid, packet.active);
                ChainPositionStore.setMiningPositions(packet.playerUuid, packet.mining);
                ChainPositionStore.setInteractionPositions(packet.playerUuid, packet.interaction);
                ChainPositionStore.setPlantingPositions(packet.playerUuid, packet.planting);
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406 ChainPositionsPacket \u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        context.setPacketHandled(true);
    }
}

