/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class InteractionHandler {
    private static final Set<BlockPos> PROCESSED_POSITIONS = new HashSet<BlockPos>();

    public static boolean isValidInteractionTool(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof ShearsItem || item instanceof BrushItem;
    }

    @Deprecated
    public static void handleChainInteraction(ServerPlayer player, PlayerInteractEvent.RightClickBlock event) {
        InteractionHandler.tryChainInteraction(player, (ServerLevel)event.getLevel(), event.getPos(), event.getFace(), event.getHitVec().getLocation(), event.getHand());
    }

    public static boolean tryChainInteraction(ServerPlayer player, ServerLevel level, BlockPos pos, Direction side, Vec3 hitVec, InteractionHand hand) {
        PROCESSED_POSITIONS.clear();
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return false;
        }
        BlockState initialState = level.getBlockState(pos);
        if (initialState.isAir()) {
            return false;
        }
        Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u4ea4\u4e92: {}", (Object)initialState.getBlock().getDescriptionId());
        BlockHitResult initialHit = new BlockHitResult(hitVec, side, pos, false);
        int maxBlocks = player.isCreative() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        boolean includeDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int processedCount = InteractionHandler.floodFillInteraction(player, level, initialState, initialHit, hand, maxBlocks, (Integer)CommonConfig.INSTANCE.maxChainDepth.get(), includeDiagonal);
        if (processedCount > 0) {
            NetworkHandler.sendToPlayer(new ChainActionPacket("interaction", processedCount), player);
            return true;
        }
        return false;
    }

    private static int floodFillInteraction(ServerPlayer player, ServerLevel level, BlockState targetState, BlockHitResult initialHit, InteractionHand hand, int maxBlocks, int maxDepth, boolean includeDiagonal) {
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        queue.add(new BlockSearchNode(initialHit.getBlockPos(), 0));
        int processedCount = 0;
        ItemStack heldItem = player.getItemInHand(hand);
        while (!queue.isEmpty() && processedCount < maxBlocks) {
            BlockState state;
            BlockSearchNode node = (BlockSearchNode)queue.poll();
            BlockPos pos = node.pos;
            if (node.depth > maxDepth || PROCESSED_POSITIONS.contains(pos) || !InteractionHandler.isMatchingBlock(state = level.getBlockState(pos), targetState)) continue;
            if (heldItem.isEmpty() || heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) break;
            PROCESSED_POSITIONS.add(pos);
            BlockHitResult hit = new BlockHitResult(initialHit.getLocation(), initialHit.getDirection(), pos, false);
            UseOnContext context = new UseOnContext((Player)player, hand, hit);
            InteractionResult result = heldItem.useOn(context);
            if (result.consumesAction()) {
                ++processedCount;
                Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u6210\u529f: {}", (Object)pos);
            }
            for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
            }
        }
        Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u65b9\u5757", (Object)processedCount);
        return processedCount;
    }

    private static boolean isMatchingBlock(BlockState state, BlockState target) {
        if (state.isAir() || target.isAir()) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.matchBlockState.get()).booleanValue()) {
            return state.equals(target);
        }
        return state.getBlock() == target.getBlock();
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.above());
        neighbors.add(pos.below());
        neighbors.add(pos.north());
        neighbors.add(pos.south());
        neighbors.add(pos.east());
        neighbors.add(pos.west());
        if (includeDiagonal) {
            neighbors.add(pos.north().east());
            neighbors.add(pos.north().west());
            neighbors.add(pos.south().east());
            neighbors.add(pos.south().west());
            neighbors.add(pos.above().north());
            neighbors.add(pos.above().south());
            neighbors.add(pos.above().east());
            neighbors.add(pos.above().west());
            neighbors.add(pos.below().north());
            neighbors.add(pos.below().south());
            neighbors.add(pos.below().east());
            neighbors.add(pos.below().west());
            neighbors.add(pos.above().north().east());
            neighbors.add(pos.above().north().west());
            neighbors.add(pos.above().south().east());
            neighbors.add(pos.above().south().west());
            neighbors.add(pos.below().north().east());
            neighbors.add(pos.below().north().west());
            neighbors.add(pos.below().south().east());
            neighbors.add(pos.below().south().west());
        }
        return neighbors;
    }

    private static class BlockSearchNode {
        final BlockPos pos;
        final int depth;

        BlockSearchNode(BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }
    }
}

