/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.CommonConfig;

@EventBusSubscriber(modid="onekeyminer")
public class UnifiedChainHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        try {
            if (!ChainModeCapability.isChainModeActive((Player)player2)) {
                return;
            }
            if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player2.isShiftKeyDown()) {
                return;
            }
            if (player2.isCreative() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
                return;
            }
            if (!UnifiedChainHandler.isToolItem(player2.getItemInHand(event.getHand()))) {
                return;
            }
            ItemStack heldItem = player2.getItemInHand(event.getHand());
            BlockState targetState = event.getLevel().getBlockState(event.getPos());
            if (InteractionHandler.isValidInteractionTool(heldItem)) {
                Onekeyminer.LOGGER.debug("\u89e6\u53d1\u5de5\u5177\u8fde\u9501\u4ea4\u4e92: {}", (Object)heldItem.getItem().getClass().getSimpleName());
                InteractionHandler.tryChainInteraction(player2, (ServerLevel)event.getLevel(), event.getPos(), event.getFace(), event.getHitVec().getLocation(), event.getHand());
            } else if (UnifiedChainHandler.isPlantableItem(heldItem)) {
                PlantingHandler.handleChainPlanting(player2, event);
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u73a9\u5bb6\u4ea4\u4e92\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        try {
            if (!ChainModeCapability.isChainModeActive((Player)player2)) {
                return;
            }
            ItemStack tool = player2.getMainHandItem();
            BlockState state = event.getState();
            ChainHandler.tryChainMine(player2, event.getPos(), state, tool);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u65b9\u5757\u7834\u574f\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    public static boolean isToolItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof ShearsItem || item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || UnifiedChainHandler.isPlantableItem(stack);
    }

    public static boolean isPlantableItem(ItemStack stack) {
        return PlantingHandler.isPlantableItem(stack);
    }
}

