/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.client.ClientUtils;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.ChainModePacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

@EventBusSubscriber(modid="onekeyminer", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class KeyBindings {
    public static final KeyMapping CHAIN_KEY = new KeyMapping("key.onekeyminer.chain", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.getOrCreate(96), "key.categories.onekeyminer");
    private static boolean chainModeActive = false;
    private static int packetCounter = 0;
    private static int frozenTimerCounter = 0;
    private static long lastCheckTime = 0L;
    private static Timer timer = null;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(CHAIN_KEY);
        NeoForge.EVENT_BUS.addListener(KeyBindings::onKeyInput);
    }

    public static void registerClientTick() {
        Onekeyminer.LOGGER.info("\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u5b9a\u65f6\u5668");
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer("ChainModeTimer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                KeyBindings.handleTimerTick();
            }
        }, 0L, 100L);
        lastCheckTime = System.currentTimeMillis();
    }

    public static void onKeyInput(InputEvent.Key event) {
        if (CHAIN_KEY.consumeClick()) {
            if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
                chainModeActive = true;
                NetworkHandler.sendToServer(new ChainModePacket(true));
                packetCounter = 0;
            } else {
                chainModeActive = !chainModeActive;
                NetworkHandler.sendToServer(new ChainModePacket(chainModeActive));
                if (chainModeActive) {
                    frozenTimerCounter = (Integer)ClientConfig.INSTANCE.frozentimer.get() * 1000;
                }
                ClientUtils.showStatusMessage(chainModeActive ? "message.onekeyminer.mode_enabled" : "message.onekeyminer.mode_disabled");
            }
        }
    }

    public static void handleTimerTick() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null || minecraft.player == null || minecraft.level == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastCheckTime;
        lastCheckTime = currentTime;
        if (elapsed <= 0L || elapsed > 5000L) {
            return;
        }
        if (((Boolean)ClientConfig.INSTANCE.requireKeyHold.get()).booleanValue()) {
            if (CHAIN_KEY.isDown()) {
                if ((packetCounter = (int)((long)packetCounter + elapsed)) >= 500) {
                    minecraft.execute(() -> NetworkHandler.sendToServer(new ChainModePacket(true)));
                    packetCounter = 0;
                }
            } else if (chainModeActive) {
                chainModeActive = false;
                minecraft.execute(() -> NetworkHandler.sendToServer(new ChainModePacket(false)));
            }
        } else if (chainModeActive && frozenTimerCounter > 0 && (frozenTimerCounter = (int)((long)frozenTimerCounter - elapsed)) <= 0) {
            chainModeActive = false;
            minecraft.execute(() -> {
                NetworkHandler.sendToServer(new ChainModePacket(false));
                ClientUtils.showStatusMessage("message.onekeyminer.mode_disabled");
            });
        }
    }
}

