/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.config;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.xiyu.yee.onekeyminer.config.ConfigUtils;

public class CommonConfig {
    public static final ModConfigSpec SPEC;
    public static final CommonConfig INSTANCE;
    public final ModConfigSpec.IntValue maxChainBlocks;
    public final ModConfigSpec.ConfigValue<List<? extends String>> nonChainableBlocks;
    public final ModConfigSpec.ConfigValue<List<? extends String>> seedBlacklist;
    public final ModConfigSpec.BooleanValue enableDiagonalChaining;
    public final ModConfigSpec.IntValue maxMiningDepth;
    public final ModConfigSpec.BooleanValue teleportDropsToPlayer;
    public final ModConfigSpec.BooleanValue ignoreToolCompatibility;
    public final ModConfigSpec.BooleanValue matchBlockState;
    public final ModConfigSpec.BooleanValue enableInCreative;
    public final ModConfigSpec.BooleanValue requireSneaking;
    public final ModConfigSpec.IntValue maxBlocksInChain;
    public final ModConfigSpec.IntValue maxBlocksInChainCreative;
    public final ModConfigSpec.IntValue maxChainDepth;

    private CommonConfig(ModConfigSpec.Builder builder) {
        builder.comment("\u901a\u7528\u914d\u7f6e||Common Config").push("general");
        this.maxChainBlocks = builder.comment("\u8fde\u9501\u64cd\u4f5c\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain operations").defineInRange("maxChainBlocks", 64, 1, 4096);
        this.nonChainableBlocks = builder.comment("\u4e0d\u5141\u8bb8\u8fde\u9501\u6316\u6398\u7684\u65b9\u5757\u9ed1\u540d\u5355||Blocks that should not be chain mined").defineList("nonChainableBlocks", () -> {
            ArrayList<String> defaults = new ArrayList<String>();
            defaults.add("minecraft:stone");
            defaults.add("minecraft:bedrock");
            return defaults;
        }, obj -> obj instanceof String);
        this.seedBlacklist = builder.comment("\u4e0d\u5141\u8bb8\u8fde\u9501\u79cd\u690d\u7684\u79cd\u5b50\u9ed1\u540d\u5355||Seeds that should not be chain planted").defineList("seedBlacklist", ArrayList::new, obj -> obj instanceof String);
        this.enableDiagonalChaining = builder.comment("\u662f\u5426\u5141\u8bb8\u5bf9\u89d2\u7ebf\u8fde\u9501\uff08\u5141\u8bb8\u5bf9\u89d2\u8fde\u63a5\u7684\u65b9\u5757\u53c2\u4e0e\u8fde\u9501\uff09||Whether to allow diagonal chaining (allow blocks connected diagonally to participate in chain mining)").define("enableDiagonalChaining", false);
        this.maxMiningDepth = builder.comment("\u6700\u5927\u6316\u6398\u6df1\u5ea6\uff08\u9632\u6b62\u8fde\u9501\u8fc7\u6df1\uff09||Maximum mining depth (prevent chain mining from being too deep)").defineInRange("maxMiningDepth", 16, 1, 64);
        this.teleportDropsToPlayer = builder.comment("\u662f\u5426\u5c06\u8fde\u9501\u6316\u6398\u7684\u6389\u843d\u7269\u4f20\u9001\u5230\u73a9\u5bb6\u8eab\u4e0b||Whether to teleport the drops from chain mining to the player").define("teleportDropsToPlayer", false);
        this.ignoreToolCompatibility = builder.comment("\u662f\u5426\u5ffd\u7565\u5de5\u5177\u517c\u5bb9\u6027\u68c0\u67e5||Whether to ignore tool compatibility checks").define("ignoreToolCompatibility", true);
        this.matchBlockState = builder.comment("\u662f\u5426\u5339\u914d\u5b8c\u6574\u7684\u65b9\u5757\u72b6\u6001\u800c\u4e0d\u4ec5\u4ec5\u662f\u65b9\u5757\u7c7b\u578b||Whether to match the complete block state rather than just the block type").define("matchBlockState", false);
        this.enableInCreative = builder.comment("\u521b\u9020\u6a21\u5f0f\u662f\u5426\u542f\u7528\u8fde\u9501\u6316\u6398||Whether to enable chain mining in creative mode").define("enableInCreative", true);
        this.requireSneaking = builder.comment("\u662f\u5426\u9700\u8981\u4e0b\u8e72\u624d\u80fd\u89e6\u53d1\u8fde\u9501\u6316\u6398||Whether to require sneaking to trigger chain mining").define("requireSneaking", false);
        this.maxBlocksInChain = builder.comment("\u5b58\u6d3b\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain mining in survival mode").defineInRange("maxBlocksInChain", 64, 1, 4096);
        this.maxBlocksInChainCreative = builder.comment("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain mining in creative mode").defineInRange("maxBlocksInChainCreative", 256, 1, 16384);
        this.maxChainDepth = builder.comment("\u6700\u5927\u8fde\u9501\u641c\u7d22\u6df1\u5ea6||Maximum chain search depth").defineInRange("maxChainDepth", 16, 1, 64);
        builder.pop();
    }

    public boolean isBlockMineable(String blockId) {
        String resourceId = this.convertToResourceId(blockId);
        for (String blacklistedBlock : (List)this.nonChainableBlocks.get()) {
            if (!resourceId.equals(blacklistedBlock)) continue;
            return false;
        }
        return true;
    }

    private String convertToResourceId(String descriptionId) {
        String[] parts;
        if (descriptionId == null) {
            return "";
        }
        if (descriptionId.startsWith("block.") && (parts = descriptionId.split("\\.")).length >= 3) {
            return parts[1] + ":" + parts[2];
        }
        if (descriptionId.contains(":")) {
            return descriptionId;
        }
        if (!descriptionId.contains(".") && !descriptionId.contains(":")) {
            return "minecraft:" + descriptionId;
        }
        return descriptionId;
    }

    public boolean isSeedBlacklisted(String seedId) {
        return ((List)this.seedBlacklist.get()).contains(seedId);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (CommonConfig)specPair.getLeft();
        ConfigUtils.loadConfig(SPEC);
    }
}

