/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ModConfigSpec SPEC;
    public static final ServerConfig INSTANCE;
    public final ModConfigSpec.BooleanValue toolProtectionEnabled;
    public final ModConfigSpec.DoubleValue toolDurabilityThreshold;
    public final ModConfigSpec.BooleanValue hungerProtectionEnabled;
    public final ModConfigSpec.DoubleValue hungerThreshold;
    public final ModConfigSpec.BooleanValue experienceMultiplierEnabled;
    public final ModConfigSpec.DoubleValue experienceMultiplier;

    private ServerConfig(ModConfigSpec.Builder builder) {
        builder.comment("\u670d\u52a1\u5668\u914d\u7f6e||Server Config").push("server");
        this.toolProtectionEnabled = builder.comment("\u542f\u7528\u5de5\u5177\u4fdd\u62a4\u6a21\u5f0f\uff08\u9632\u6b62\u5de5\u5177\u8010\u4e45\u8fc7\u4f4e\u5bfc\u81f4\u635f\u574f\uff09||Enable tool protection mode (prevent tool durability from being too low)").define("toolProtectionEnabled", true);
        this.toolDurabilityThreshold = builder.comment("\u5de5\u5177\u8010\u4e45\u9608\u503c (\u5982\u679c\u662f\u5c0f\u4e8e\u7b49\u4e8e1.0\u7684\u503c\u5219\u8868\u793a\u767e\u5206\u6bd4\uff0c\u5927\u4e8e1.0\u8868\u793a\u56fa\u5b9a\u503c)||Tool durability threshold (if the value is less than or equal to 1.0, it represents a percentage, otherwise it represents a fixed value)").defineInRange("toolDurabilityThreshold", 0.1, 0.01, 1000.0);
        this.hungerProtectionEnabled = builder.comment("\u542f\u7528\u9965\u997f\u5ea6\u4fdd\u62a4\uff08\u9632\u6b62\u9965\u997f\u503c\u8fc7\u4f4e\u65f6\u65e0\u6cd5\u6316\u6398\uff09||Enable hunger protection (prevent mining when hunger is too low)").define("hungerProtectionEnabled", true);
        this.hungerThreshold = builder.comment("\u9965\u997f\u5ea6\u9608\u503c (\u6700\u5c0f\u503c\u4e3a0\uff0c\u6700\u5927\u503c\u4e3a20)||Hunger threshold (minimum value is 0, maximum value is 20)").defineInRange("hungerThreshold", 3.0, 0.0, 20.0);
        this.experienceMultiplierEnabled = builder.comment("\u542f\u7528\u7ecf\u9a8c\u4fee\u6b63\uff08\u8c03\u6574\u8fde\u9501\u6316\u6398\u83b7\u5f97\u7684\u7ecf\u9a8c\uff09||Enable experience multiplier (adjust the experience gained from chain mining)").define("experienceMultiplierEnabled", true);
        this.experienceMultiplier = builder.comment("\u7ecf\u9a8c\u500d\u7387\u8c03\u6574 (1.0\u4e3a\u539f\u59cb\u7ecf\u9a8c\u503c)||Experience multiplier adjustment (1.0 is the original experience value)").defineInRange("experienceMultiplier", 0.8, 0.1, 2.0);
        builder.pop();
    }

    public boolean isToolSuitable(int currentDurability, int maxDurability) {
        if (!((Boolean)this.toolProtectionEnabled.get()).booleanValue()) {
            return true;
        }
        double threshold = (Double)this.toolDurabilityThreshold.get();
        if (threshold <= 1.0) {
            return (double)currentDurability > (double)maxDurability * threshold;
        }
        return (double)currentDurability > threshold;
    }

    public boolean isHungerSufficient(int foodLevel) {
        if (!((Boolean)this.hungerProtectionEnabled.get()).booleanValue()) {
            return true;
        }
        return (double)foodLevel >= (Double)this.hungerThreshold.get();
    }

    public float getExperienceMultiplier() {
        if (!((Boolean)this.experienceMultiplierEnabled.get()).booleanValue()) {
            return 1.0f;
        }
        return ((Double)this.experienceMultiplier.get()).floatValue();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (ServerConfig)specPair.getLeft();
    }
}

