/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.event;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="onekeyminer")
public class ServerEventHandler {
    private static final String DISCORD_LINK = "https://discord.gg/ASVG5n5xAg";

    public static void init() {
        NeoForge.EVENT_BUS.register(ServerEventHandler.class);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        MinecraftServer server;
        if (event.getEntity() instanceof ServerPlayer && (server = (player = (ServerPlayer)event.getEntity()).getServer()) != null) {
            server.executeBlocking(new Runnable(){

                @Override
                public void run() {
                    if (player.isRemoved() || !player.isAlive()) {
                        return;
                    }
                    CommandSourceStack source = server.createCommandSourceStack();
                    server.getCommands().performPrefixedCommand(source, "tellraw " + player.getScoreboardName() + " {\"translate\":\"message.onekeyminer.welcome\",\"color\":\"aqua\"}");
                    server.getCommands().performPrefixedCommand(source, "tellraw " + player.getScoreboardName() + " [{\"translate\":\"message.onekeyminer.discord.invite\",\"color\":\"green\"},{\"text\":\"https://discord.gg/ASVG5n5xAg\",\"color\":\"blue\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"https://discord.gg/ASVG5n5xAg\"},\"hoverEvent\":{\"action\":\"show_text\",\"contents\":{\"translate\":\"message.onekeyminer.discord.tooltip\"}}}]");
                }
            });
        }
    }
}

