/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.xiyu.yee.onekeyminer.client.ClientUtils;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class BlocksMinedPacket
implements IOneKeyPacket {
    private final int blockCount;

    public BlocksMinedPacket(int blockCount) {
        this.blockCount = blockCount;
    }

    public static BlocksMinedPacket fromNetwork(FriendlyByteBuf buf) {
        return new BlocksMinedPacket(buf.readInt());
    }

    private BlocksMinedPacket(FriendlyByteBuf buf) {
        this.blockCount = buf.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.blockCount);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.BLOCKS_MINED_ID;
    }

    public CustomPacketPayload.Type<?> type() {
        return NetworkHandler.BLOCKS_MINED_TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(BlocksMinedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player != null && ((Boolean)ClientConfig.INSTANCE.showBlockCount.get()).booleanValue()) {
                ClientUtils.showBlockCountMessage(packet.blockCount);
            }
        });
    }
}

