/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainModePacket
implements IOneKeyPacket {
    private final boolean active;

    public ChainModePacket(boolean active) {
        this.active = active;
    }

    public static ChainModePacket fromNetwork(FriendlyByteBuf buf) {
        return new ChainModePacket(buf.readBoolean());
    }

    private ChainModePacket(FriendlyByteBuf buf) {
        this.active = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_MODE_ID;
    }

    public CustomPacketPayload.Type<?> type() {
        return NetworkHandler.CHAIN_MODE_TYPE;
    }

    public static void handleOnServer(ChainModePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp;
            if (context.player() != null && (patt0$temp = context.player()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ChainModeCapability.setChainMode(serverPlayer, packet.active);
            }
        });
    }

    public static void handleOnClient(ChainModePacket packet, IPayloadContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        context.enqueueWork(() -> {
            if (minecraft.player == null) {
                return;
            }
            MutableComponent message = Component.translatable((String)(packet.active ? "message.onekeyminer.chain_mode_on" : "message.onekeyminer.chain_mode_off"));
            minecraft.player.displayClientMessage((Component)message, true);
        });
    }
}

