/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ConfigSyncPacket
implements IOneKeyPacket {
    private final String configKey;
    private final String configValue;

    public ConfigSyncPacket(String configKey, String configValue) {
        this.configKey = configKey;
        this.configValue = configValue;
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CONFIG_SYNC_ID;
    }

    public CustomPacketPayload.Type<?> type() {
        return NetworkHandler.CONFIG_SYNC_TYPE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.configKey);
        buffer.writeUtf(this.configValue);
    }

    public static ConfigSyncPacket fromNetwork(FriendlyByteBuf buffer) {
        String key = buffer.readUtf();
        String value = buffer.readUtf();
        return new ConfigSyncPacket(key, value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(ConfigSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            String key = packet.configKey;
            String value = packet.configValue;
            switch (key) {
                case "keyhold": {
                    ClientConfig.INSTANCE.requireKeyHold.set((Object)Boolean.parseBoolean(value));
                    break;
                }
                case "showcount": {
                    ClientConfig.INSTANCE.showBlockCount.set((Object)Boolean.parseBoolean(value));
                    break;
                }
                case "messagestyle": {
                    ClientConfig.INSTANCE.messageStyle.set((Object)value);
                    break;
                }
                default: {
                    Onekeyminer.LOGGER.warn("\u6536\u5230\u672a\u77e5\u914d\u7f6e\u952e: {}", (Object)key);
                }
            }
            Onekeyminer.LOGGER.debug("\u5ba2\u6237\u7aef\u914d\u7f6e\u5df2\u66f4\u65b0: {} = {}", (Object)key, (Object)value);
        });
    }
}

