/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.client.renderer;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetRenderHandler;
import dev.kvnmtz.createkineticilluminator.network.KineticIlluminatorBeamPacket;
import dev.kvnmtz.createkineticilluminator.registry.ModItems;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_7833;

public class KineticIlluminatorRenderHandler
extends ShootableGadgetRenderHandler {
    private static final int SCROLL_ANIMATION_DURATION_TICKS = 10;
    private float scrollAnimationProgress = 0.0f;
    private float scrollDirection = 0.0f;
    private int scrollStartTick = 0;
    public List<PhotonBeam> cachedBeams;

    public void tick() {
        super.tick();
        this.updateScrollAnimation();
        this.handleBeams();
    }

    protected void playSound(class_1268 hand, class_243 position) {
    }

    public void playSound(class_243 position, KineticIlluminatorBeamPacket.ShootType shootType) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_2338 soundPos = class_2338.method_49638((class_2374)position);
        AllSoundEvents.WORLDSHAPER_PLACE.play((class_1937)client.field_1687, (class_1657)client.field_1724, (class_2382)soundPos, 0.1f, 0.1f);
        if (shootType == KineticIlluminatorBeamPacket.ShootType.PLACE_BLOCK) {
            client.field_1687.method_8396((class_1657)client.field_1724, soundPos, class_3417.field_14703, class_3419.field_15248, 0.3f, 1.5f);
        } else {
            client.field_1687.method_8396((class_1657)client.field_1724, soundPos, class_3417.field_19344, class_3419.field_15248, 0.3f, 1.5f);
        }
    }

    protected boolean appliesTo(class_1799 stack) {
        return stack.method_31574((class_1792)ModItems.KINETIC_ILLUMINATOR.get());
    }

    protected void transformTool(class_4587 ms, float flip, float equipProgress, float recoil, float pt) {
        ms.method_46416(flip * -0.1f, 0.1f, -0.4f);
        ms.method_22907(class_7833.field_40716.rotationDegrees(flip * 5.0f));
    }

    protected void transformHand(class_4587 ms, float flip, float equipProgress, float recoil, float pt) {
    }

    public void triggerScrollAnimation(float scrollAmount) {
        this.scrollDirection = scrollAmount > 0.0f ? 1.0f : -1.0f;
        this.scrollStartTick = AnimationTickHolder.getTicks();
        this.scrollAnimationProgress = 1.0f;
    }

    private void updateScrollAnimation() {
        if (this.scrollAnimationProgress <= 0.0f) {
            return;
        }
        int currentTick = AnimationTickHolder.getTicks();
        int elapsed = currentTick - this.scrollStartTick;
        if (elapsed >= 10) {
            this.scrollAnimationProgress = 0.0f;
        } else {
            int t = elapsed / 10;
            this.scrollAnimationProgress = (float)Math.pow(2.0, -10 * t);
        }
    }

    public float getScrollAnimationMultiplier(float partialTicks) {
        if (this.scrollAnimationProgress <= 0.0f) {
            return 0.0f;
        }
        float currentTick = (float)AnimationTickHolder.getTicks() + partialTicks;
        float elapsed = currentTick - (float)this.scrollStartTick;
        if (elapsed >= 10.0f) {
            return 0.0f;
        }
        float t = elapsed / 10.0f;
        float interpolatedProgress = (float)Math.pow(2.0, -10.0f * t);
        return interpolatedProgress * this.scrollDirection;
    }

    private void handleBeams() {
        if (this.cachedBeams == null) {
            this.cachedBeams = new LinkedList<PhotonBeam>();
        }
        this.cachedBeams.removeIf(beam -> beam.thickness < 0.1f);
        if (this.cachedBeams.isEmpty()) {
            return;
        }
        this.cachedBeams.forEach(beam -> Outliner.getInstance().endChasingLine(beam, beam.startPos, beam.endPos, 1.0f - beam.thickness, false).disableLineNormals().colored(0xFFFF00).lineWidth(beam.thickness * 1.0f / 8.0f));
        this.cachedBeams.forEach(beam -> beam.thickness *= 0.6f);
    }

    public void addBeam(PhotonBeam beam) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        Random random = new Random();
        if (beam.shootType == KineticIlluminatorBeamPacket.ShootType.PLACE_BLOCK) {
            double centerX = beam.endPos.field_1352;
            double centerY = beam.endPos.field_1351;
            double centerZ = beam.endPos.field_1350;
            float radius = 1.25f;
            for (int i = 0; i < 10; ++i) {
                double theta = random.nextDouble() * 2.0 * Math.PI;
                double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
                double offsetX = (double)radius * Math.sin(phi) * Math.cos(theta);
                double offsetY = (double)radius * Math.sin(phi) * Math.sin(theta);
                double offsetZ = (double)radius * Math.cos(phi);
                double particleX = centerX + offsetX;
                double particleY = centerY + offsetY;
                double particleZ = centerZ + offsetZ;
                float speed = 0.1f + random.nextFloat() * 0.05f;
                double velocityX = -offsetX / (double)radius * (double)speed;
                double velocityY = -offsetY / (double)radius * (double)speed;
                double velocityZ = -offsetZ / (double)radius * (double)speed;
                level.method_8406((class_2394)class_2398.field_11207, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
            }
        } else {
            double x = beam.endPos.field_1352;
            double y = beam.endPos.field_1351;
            double z = beam.endPos.field_1350;
            Supplier<Double> randomSpeed = () -> (random.nextDouble() - 0.5) * (double)0.2f;
            for (int i = 0; i < 10; ++i) {
                level.method_8406((class_2394)class_2398.field_11207, x, y, z, randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue());
            }
        }
        this.cachedBeams.add(beam);
    }

    public static class PhotonBeam {
        public float thickness = 1.0f;
        public final class_243 startPos;
        public final class_243 endPos;
        public final KineticIlluminatorBeamPacket.ShootType shootType;

        public PhotonBeam(class_243 startPos, class_243 endPos, KineticIlluminatorBeamPacket.ShootType shootType) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.shootType = shootType;
        }
    }
}

