/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.kvnmtz.createkineticilluminator.client.CreateKineticIlluminatorClient;
import dev.kvnmtz.createkineticilluminator.client.renderer.KineticIlluminatorRenderHandler;
import dev.kvnmtz.createkineticilluminator.registry.ModPackets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;

public class KineticIlluminatorBeamPacket
extends BaseS2CMessage {
    public final class_243 barrelPos;
    public final class_1268 usedHand;
    public final boolean self;
    public final class_2338 targetPos;
    public final ShootType shootType;

    public KineticIlluminatorBeamPacket(class_243 barrelPos, class_1268 usedHand, boolean self, class_2338 targetPos, ShootType shootType) {
        this.barrelPos = barrelPos;
        this.usedHand = usedHand;
        this.self = self;
        this.targetPos = targetPos;
        this.shootType = shootType;
    }

    public KineticIlluminatorBeamPacket(class_2540 buf) {
        this.barrelPos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.usedHand = buf.readBoolean() ? class_1268.field_5808 : class_1268.field_5810;
        this.self = buf.readBoolean();
        this.targetPos = buf.method_10811();
        this.shootType = buf.readBoolean() ? ShootType.PLACE_BLOCK : ShootType.DESTROY_BLOCK;
    }

    public MessageType getType() {
        return ModPackets.BEAM_PACKET;
    }

    public void write(class_2540 buf) {
        buf.writeDouble(this.barrelPos.field_1352);
        buf.writeDouble(this.barrelPos.field_1351);
        buf.writeDouble(this.barrelPos.field_1350);
        buf.writeBoolean(this.usedHand == class_1268.field_5808);
        buf.writeBoolean(this.self);
        buf.method_10807(this.targetPos);
        buf.writeBoolean(this.shootType == ShootType.PLACE_BLOCK);
    }

    @Environment(value=EnvType.CLIENT)
    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            class_1297 cameraEntity = class_310.method_1551().method_1560();
            if (cameraEntity == null) {
                return;
            }
            if (cameraEntity.method_19538().method_1022(this.barrelPos) > 100.0) {
                return;
            }
            KineticIlluminatorRenderHandler handler = CreateKineticIlluminatorClient.KINETIC_ILLUMINATOR_RENDER_HANDLER;
            handler.addBeam(new KineticIlluminatorRenderHandler.PhotonBeam(this.barrelPos, this.targetPos.method_46558(), this.shootType));
            if (this.self) {
                handler.shoot(this.usedHand, this.barrelPos);
                handler.playSound(this.barrelPos, this.shootType);
            } else {
                handler.playSound(this.barrelPos, this.shootType);
            }
        });
    }

    public static enum ShootType {
        PLACE_BLOCK,
        DESTROY_BLOCK;

    }
}

