/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.network;

import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.kvnmtz.createkineticilluminator.network.KineticIlluminatorBeamPacket;
import dev.kvnmtz.createkineticilluminator.registry.ModItems;
import dev.kvnmtz.createkineticilluminator.registry.ModPackets;
import dev.kvnmtz.createkineticilluminator.util.SoundUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6089;

public class KineticIlluminatorShootPacket
extends BaseC2SMessage {
    private final class_2338 targetPos;
    private final int lightLevel;
    private final class_1268 usedHand;
    private static final int FLAG_BLOCK_UPDATE = 1;
    private static final int FLAG_CLIENT_SYNC = 2;

    public KineticIlluminatorShootPacket(class_2338 targetPos, int lightLevel, class_1268 usedHand) {
        this.targetPos = targetPos;
        this.lightLevel = lightLevel;
        this.usedHand = usedHand;
    }

    public KineticIlluminatorShootPacket(class_2540 buf) {
        this.targetPos = buf.method_10811();
        this.lightLevel = buf.readByte();
        this.usedHand = buf.readBoolean() ? class_1268.field_5808 : class_1268.field_5810;
    }

    public MessageType getType() {
        return ModPackets.SHOOT_PACKET;
    }

    public void write(class_2540 buf) {
        buf.method_10807(this.targetPos);
        buf.writeByte(this.lightLevel);
        buf.writeBoolean(this.usedHand == class_1268.field_5808);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            class_3222 player = (class_3222)context.getPlayer();
            if (player.method_33571().method_1022(this.targetPos.method_46558()) >= 10.0) {
                return;
            }
            if (this.lightLevel < 1 || this.lightLevel > 15) {
                return;
            }
            class_3218 serverLevel = player.method_51469();
            class_2680 blockState = serverLevel.method_8320(this.targetPos);
            boolean destroyLightBlock = blockState.method_27852(class_2246.field_31037);
            if (destroyLightBlock) {
                KineticIlluminatorShootPacket.destroyLightBlock(serverLevel, blockState, this.targetPos);
            } else if (!KineticIlluminatorShootPacket.placeLightBlock(this.lightLevel, serverLevel, blockState, this.targetPos, player)) {
                return;
            }
            boolean mainHand = this.usedHand == class_1268.field_5808;
            class_243 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((class_1657)player, (boolean)mainHand, (class_243)new class_243((double)0.35f, (double)-0.1f, 1.0));
            KineticIlluminatorBeamPacket.ShootType shootType = destroyLightBlock ? KineticIlluminatorBeamPacket.ShootType.DESTROY_BLOCK : KineticIlluminatorBeamPacket.ShootType.PLACE_BLOCK;
            player.method_7357().method_7906((class_1792)ModItems.KINETIC_ILLUMINATOR.get(), 10);
            new KineticIlluminatorBeamPacket(barrelPos, this.usedHand, false, this.targetPos, shootType).sendTo(ModPackets.getTrackingPlayers(player));
            new KineticIlluminatorBeamPacket(barrelPos, this.usedHand, true, this.targetPos, shootType).sendTo(player);
        });
    }

    private static int getRequiredGlowstoneDust(int lightLevel) {
        if (lightLevel <= 3) {
            return 1;
        }
        if (lightLevel <= 7) {
            return 2;
        }
        if (lightLevel <= 11) {
            return 3;
        }
        return 4;
    }

    private static void destroyLightBlock(class_3218 serverLevel, class_2680 blockState, class_2338 targetPos) {
        if (((Boolean)blockState.method_11654((class_2769)class_6089.field_31188)).booleanValue()) {
            serverLevel.method_8652(targetPos, class_2246.field_10382.method_9564(), 3);
        } else {
            serverLevel.method_8652(targetPos, class_2246.field_10124.method_9564(), 2);
        }
    }

    private static boolean placeLightBlock(int lightLevel, class_3218 serverLevel, class_2680 blockState, class_2338 targetPos, class_3222 player) {
        boolean isWater = blockState.method_27852(class_2246.field_10382);
        if (!blockState.method_26215() && !isWater) {
            return false;
        }
        boolean isCreative = player.method_31549().field_7477;
        if (!isCreative && !KineticIlluminatorShootPacket.couldGlowstoneBeConsumed(lightLevel, player)) {
            return false;
        }
        class_2680 lightBlockState = (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(lightLevel));
        if (isWater) {
            lightBlockState = (class_2680)lightBlockState.method_11657((class_2769)class_6089.field_31188, (Comparable)Boolean.valueOf(true));
        }
        serverLevel.method_8652(targetPos, lightBlockState, 2);
        return true;
    }

    private static boolean couldGlowstoneBeConsumed(int lightLevel, class_3222 player) {
        int requiredDust = KineticIlluminatorShootPacket.getRequiredGlowstoneDust(lightLevel);
        class_1661 inventory = player.method_31548();
        int availableDust = 0;
        for (class_1799 stack : inventory.field_7547) {
            if (!stack.method_31574(class_1802.field_8601)) continue;
            availableDust += stack.method_7947();
        }
        if (availableDust < requiredDust) {
            SoundUtils.playSoundForPlayer(player, (class_3414)class_3417.field_14624.comp_349(), 1.0f, 0.5f);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNot enough Glowstone Dust"), true);
            return false;
        }
        int dustToRemove = requiredDust;
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_31574(class_1802.field_8601)) {
                int removeFromStack = Math.min(dustToRemove, stack.method_7947());
                stack.method_7934(removeFromStack);
                dustToRemove -= removeFromStack;
            }
            if (dustToRemove != 0) continue;
            break;
        }
        return true;
    }
}

