/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetRenderHandler;
import dev.kvnmtz.createkineticilluminator.network.KineticIlluminatorShootPacket;
import dev.kvnmtz.createkineticilluminator.registry.ModItems;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class KineticIlluminatorRenderHandler
extends ShootableGadgetRenderHandler {
    private static final int SCROLL_ANIMATION_DURATION_TICKS = 10;
    private float scrollAnimationProgress = 0.0f;
    private float scrollDirection = 0.0f;
    private int scrollStartTick = 0;
    public List<PhotonBeam> cachedBeams;

    public void tick() {
        super.tick();
        this.updateScrollAnimation();
        this.handleBeams();
    }

    protected void playSound(InteractionHand hand, Vec3 position) {
    }

    public void playSound(Vec3 position, KineticIlluminatorShootPacket.ShootType shootType) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        BlockPos soundPos = BlockPos.m_274446_((Position)position);
        AllSoundEvents.WORLDSHAPER_PLACE.play((Level)client.f_91073_, (Player)client.f_91074_, (Vec3i)soundPos, 0.1f, 0.1f);
        if (shootType == KineticIlluminatorShootPacket.ShootType.PLACE_BLOCK) {
            client.f_91073_.m_5594_((Player)client.f_91074_, soundPos, SoundEvents.f_11736_, SoundSource.PLAYERS, 0.3f, 1.5f);
        } else {
            client.f_91073_.m_5594_((Player)client.f_91074_, soundPos, SoundEvents.f_11738_, SoundSource.PLAYERS, 0.3f, 1.5f);
        }
    }

    protected boolean appliesTo(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.KINETIC_ILLUMINATOR.get());
    }

    protected void transformTool(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
        ms.m_252880_(flip * -0.1f, 0.1f, -0.4f);
        ms.m_252781_(Axis.f_252436_.m_252977_(flip * 5.0f));
    }

    protected void transformHand(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
    }

    public void triggerScrollAnimation(float scrollAmount) {
        this.scrollDirection = scrollAmount > 0.0f ? 1.0f : -1.0f;
        this.scrollStartTick = AnimationTickHolder.getTicks();
        this.scrollAnimationProgress = 1.0f;
    }

    private void updateScrollAnimation() {
        if (this.scrollAnimationProgress <= 0.0f) {
            return;
        }
        int currentTick = AnimationTickHolder.getTicks();
        int elapsed = currentTick - this.scrollStartTick;
        if (elapsed >= 10) {
            this.scrollAnimationProgress = 0.0f;
        } else {
            int t = elapsed / 10;
            this.scrollAnimationProgress = (float)Math.pow(2.0, -10 * t);
        }
    }

    public float getScrollAnimationMultiplier(float partialTicks) {
        if (this.scrollAnimationProgress <= 0.0f) {
            return 0.0f;
        }
        float currentTick = (float)AnimationTickHolder.getTicks() + partialTicks;
        float elapsed = currentTick - (float)this.scrollStartTick;
        if (elapsed >= 10.0f) {
            return 0.0f;
        }
        float t = elapsed / 10.0f;
        float interpolatedProgress = (float)Math.pow(2.0, -10.0f * t);
        return interpolatedProgress * this.scrollDirection;
    }

    private void handleBeams() {
        if (this.cachedBeams == null) {
            this.cachedBeams = new LinkedList<PhotonBeam>();
        }
        this.cachedBeams.removeIf(beam -> beam.thickness < 0.1f);
        if (this.cachedBeams.isEmpty()) {
            return;
        }
        this.cachedBeams.forEach(beam -> Outliner.getInstance().endChasingLine(beam, beam.startPos, beam.endPos, 1.0f - beam.thickness, false).disableLineNormals().colored(0xFFFF00).lineWidth(beam.thickness * 1.0f / 8.0f));
        this.cachedBeams.forEach(beam -> beam.thickness *= 0.6f);
    }

    public void addBeam(PhotonBeam beam) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        if (beam.shootType == KineticIlluminatorShootPacket.ShootType.PLACE_BLOCK) {
            double centerX = beam.endPos.f_82479_;
            double centerY = beam.endPos.f_82480_;
            double centerZ = beam.endPos.f_82481_;
            float radius = 1.25f;
            for (int i = 0; i < 10; ++i) {
                double theta = random.nextDouble() * 2.0 * Math.PI;
                double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
                double offsetX = (double)radius * Math.sin(phi) * Math.cos(theta);
                double offsetY = (double)radius * Math.sin(phi) * Math.sin(theta);
                double offsetZ = (double)radius * Math.cos(phi);
                double particleX = centerX + offsetX;
                double particleY = centerY + offsetY;
                double particleZ = centerZ + offsetZ;
                float speed = 0.1f + random.nextFloat() * 0.05f;
                double velocityX = -offsetX / (double)radius * (double)speed;
                double velocityY = -offsetY / (double)radius * (double)speed;
                double velocityZ = -offsetZ / (double)radius * (double)speed;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
            }
        } else {
            double x = beam.endPos.f_82479_;
            double y = beam.endPos.f_82480_;
            double z = beam.endPos.f_82481_;
            Supplier<Double> randomSpeed = () -> (random.nextDouble() - 0.5) * (double)0.2f;
            for (int i = 0; i < 10; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue());
            }
        }
        this.cachedBeams.add(beam);
    }

    public static class PhotonBeam {
        public float thickness = 1.0f;
        public final Vec3 startPos;
        public final Vec3 endPos;
        public final KineticIlluminatorShootPacket.ShootType shootType;

        public PhotonBeam(Vec3 startPos, Vec3 endPos, KineticIlluminatorShootPacket.ShootType shootType) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.shootType = shootType;
        }
    }
}

