/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.client.renderer.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.kvnmtz.createkineticilluminator.client.renderer.KineticIlluminatorItemRenderer;
import dev.kvnmtz.createkineticilluminator.util.ShaderUtils;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class KineticIlluminatorItemRendererImpl {
    public static void renderPlatformAgnostic(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float pt = AnimationTickHolder.getPartialTicks();
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        renderer.renderSolid(model.getOriginalModel(), light);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean leftHanded = player.m_5737_() == HumanoidArm.LEFT;
        boolean mainHand = player.m_21205_() == stack;
        boolean offHand = player.m_21206_() == stack;
        float animation = KineticIlluminatorItemRenderer.getAnimationProgress(pt, leftHanded, mainHand);
        float multiplier = !mainHand && !offHand ? Mth.m_14031_((float)(worldTime * 5.0f)) : animation;
        int lightItensity = (int)(15.0f * Mth.m_14036_((float)multiplier, (float)0.0f, (float)1.0f));
        int glowLight = LightTexture.m_109885_((int)lightItensity, (int)Math.max(lightItensity, 4));
        if (ShaderUtils.areShadersEnabled()) {
            renderer.renderSolid(KineticIlluminatorItemRenderer.CORE.get(), glowLight);
            renderer.render(KineticIlluminatorItemRenderer.CORE_GLOW.get(), glowLight);
        } else {
            renderer.renderSolidGlowing(KineticIlluminatorItemRenderer.CORE.get(), glowLight);
            renderer.renderGlowing(KineticIlluminatorItemRenderer.CORE_GLOW.get(), glowLight);
        }
        float angle = worldTime * -25.0f;
        if (mainHand || offHand) {
            angle += 360.0f * animation;
            angle = KineticIlluminatorItemRenderer.getScrollModifiedAngle(angle, pt);
        }
        float offset = -0.155f;
        ms.m_252880_(0.0f, offset, 0.0f);
        ms.m_252781_(Axis.f_252403_.m_252977_(angle %= 360.0f));
        ms.m_252880_(0.0f, -offset, 0.0f);
        renderer.render(KineticIlluminatorItemRenderer.ACCELERATOR.get(), light);
    }
}

