/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.item;

import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.kvnmtz.createkineticilluminator.client.CreateKineticIlluminatorClient;
import dev.kvnmtz.createkineticilluminator.item.client.KineticIlluminatorHandler;
import dev.kvnmtz.createkineticilluminator.item.forge.KineticIlluminatorItemImpl;
import dev.kvnmtz.createkineticilluminator.network.KineticIlluminatorShootPacket;
import dev.kvnmtz.createkineticilluminator.registry.ModPackets;
import dev.kvnmtz.createkineticilluminator.util.SoundUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KineticIlluminatorItem
extends Item
implements CustomArmPoseItem {
    private static final int FLAG_BLOCK_UPDATE = 1;
    private static final int FLAG_CLIENT_SYNC = 2;

    protected KineticIlluminatorItem(Item.Properties properties) {
        super(properties);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static KineticIlluminatorItem create(Item.Properties properties) {
        return KineticIlluminatorItemImpl.create(properties);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    private static int getRequiredGlowstoneDust(int lightLevel) {
        if (lightLevel <= 3) {
            return 1;
        }
        if (lightLevel <= 7) {
            return 2;
        }
        if (lightLevel <= 11) {
            return 3;
        }
        return 4;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        BlockPos targetPos = KineticIlluminatorHandler.targetPos;
        if (targetPos == null) {
            return super.m_7203_(level, player, usedHand);
        }
        player.m_6672_(usedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState blockState = serverLevel.m_8055_(targetPos);
            boolean destroyLightBlock = blockState.m_60713_(Blocks.f_152480_);
            if (destroyLightBlock) {
                KineticIlluminatorItem.destroyLightBlock(serverLevel, blockState, targetPos);
            } else if (!KineticIlluminatorItem.placeLightBlock(serverLevel, blockState, targetPos, (ServerPlayer)player)) {
                return super.m_7203_(level, player, usedHand);
            }
            boolean mainHand = usedHand == InteractionHand.MAIN_HAND;
            Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (boolean)mainHand, (Vec3)new Vec3((double)0.35f, (double)-0.1f, 1.0));
            KineticIlluminatorShootPacket.ShootType shootType = destroyLightBlock ? KineticIlluminatorShootPacket.ShootType.DESTROY_BLOCK : KineticIlluminatorShootPacket.ShootType.PLACE_BLOCK;
            player.m_36335_().m_41524_((Item)this, 10);
            new KineticIlluminatorShootPacket(barrelPos, usedHand, false, targetPos, shootType).sendTo(ModPackets.getTrackingPlayers((ServerPlayer)player));
            new KineticIlluminatorShootPacket(barrelPos, usedHand, true, targetPos, shootType).sendTo((ServerPlayer)player);
        } else {
            CreateKineticIlluminatorClient.KINETIC_ILLUMINATOR_RENDER_HANDLER.dontAnimateItem(usedHand);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_36335_().m_41519_((Item)this)) {
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }

    private static void destroyLightBlock(ServerLevel serverLevel, BlockState blockState, BlockPos targetPos) {
        if (((Boolean)blockState.m_61143_((Property)LightBlock.f_153658_)).booleanValue()) {
            serverLevel.m_7731_(targetPos, Blocks.f_49990_.m_49966_(), 3);
        } else {
            serverLevel.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 2);
        }
    }

    private static boolean placeLightBlock(ServerLevel serverLevel, BlockState blockState, BlockPos targetPos, ServerPlayer player) {
        boolean isWater = blockState.m_60713_(Blocks.f_49990_);
        if (!blockState.m_60795_() && !isWater) {
            return false;
        }
        boolean isCreative = player.m_150110_().f_35937_;
        if (!isCreative && !KineticIlluminatorItem.couldGlowstoneBeConsumed(player)) {
            return false;
        }
        BlockState lightBlockState = (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(KineticIlluminatorHandler.lightLevel));
        if (isWater) {
            lightBlockState = (BlockState)lightBlockState.m_61124_((Property)LightBlock.f_153658_, (Comparable)Boolean.valueOf(true));
        }
        serverLevel.m_7731_(targetPos, lightBlockState, 2);
        return true;
    }

    private static boolean couldGlowstoneBeConsumed(ServerPlayer player) {
        int requiredDust = KineticIlluminatorItem.getRequiredGlowstoneDust(KineticIlluminatorHandler.lightLevel);
        Inventory inventory = player.m_150109_();
        int availableDust = 0;
        for (ItemStack stack : inventory.f_35974_) {
            if (!stack.m_150930_(Items.f_42525_)) continue;
            availableDust += stack.m_41613_();
        }
        if (availableDust < requiredDust) {
            SoundUtils.playSoundForPlayer(player, (SoundEvent)SoundEvents.f_12209_.m_203334_(), 1.0f, 0.5f);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cNot enough Glowstone Dust"), true);
            return false;
        }
        int dustToRemove = requiredDust;
        for (ItemStack stack : inventory.f_35974_) {
            if (stack.m_150930_(Items.f_42525_)) {
                int removeFromStack = Math.min(dustToRemove, stack.m_41613_());
                stack.m_41774_(removeFromStack);
                dustToRemove -= removeFromStack;
            }
            if (dustToRemove != 0) continue;
            break;
        }
        return true;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }
}

