/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.item.client;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.RaycastHelper;
import dev.architectury.event.EventResult;
import dev.kvnmtz.createkineticilluminator.client.CreateKineticIlluminatorClient;
import dev.kvnmtz.createkineticilluminator.registry.ModItems;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class KineticIlluminatorHandler {
    private static final Object outlineSlot = new Object();
    public static BlockPos targetPos = null;
    public static int lightLevel = 15;

    public static void tick(Minecraft client) {
        targetPos = null;
        if (KineticIlluminatorHandler.isInactive()) {
            return;
        }
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        boolean isTargetLightBlock = false;
        BlockHitResult trace = KineticIlluminatorHandler.rayTraceRange(player.m_9236_(), (Player)player, 4.5);
        if (trace.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hit = trace.m_82425_();
            if (player.m_9236_().m_8055_(hit).m_60713_(Blocks.f_152480_) && !player.m_6144_()) {
                targetPos = hit;
                isTargetLightBlock = true;
            } else {
                targetPos = trace.m_82425_().m_121945_(trace.m_82434_());
            }
        }
        if (targetPos == null) {
            float pt = AnimationTickHolder.getPartialTicks();
            Vec3 targetVec = player.m_20299_(pt).m_82549_(player.m_20154_().m_82490_(4.5));
            targetPos = BlockPos.m_274446_((Position)targetVec);
        }
        Outliner.getInstance().chaseAABB(outlineSlot, new AABB(targetPos)).colored(isTargetLightBlock ? 16460854 : 16768800).lineWidth(0.0625f);
    }

    public static EventResult onScroll(Minecraft client, double amount) {
        boolean shouldIgnoreInput;
        if (KineticIlluminatorHandler.isInactive()) {
            return EventResult.pass();
        }
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return EventResult.pass();
        }
        if (!player.m_6144_()) {
            return EventResult.pass();
        }
        boolean bl = shouldIgnoreInput = lightLevel == 1 && amount < 0.0 || lightLevel == 15 && amount > 0.0;
        if (shouldIgnoreInput) {
            return EventResult.interruptFalse();
        }
        lightLevel = Mth.m_14045_((int)((int)Math.round((double)lightLevel + amount)), (int)1, (int)15);
        player.m_5661_((Component)Component.m_237113_((String)("\u00a77Light level: \u00a7e" + lightLevel)), true);
        AllSoundEvents.SCROLL_VALUE.play((Level)client.f_91073_, (Player)client.f_91074_, (Vec3i)client.f_91074_.m_20183_());
        CreateKineticIlluminatorClient.KINETIC_ILLUMINATOR_RENDER_HANDLER.triggerScrollAnimation((float)amount);
        return EventResult.interruptFalse();
    }

    private static BlockHitResult rayTraceRange(Level level, Player player, double range) {
        Vec3 origin = player.m_146892_();
        Vec3 target = RaycastHelper.getTraceTarget((Player)player, (double)range, (Vec3)origin);
        ClipContext context = new ClipContext(origin, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return level.m_45547_(context);
    }

    private static boolean isInactive() {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return true;
        }
        if (client.f_91073_ == null || client.f_91080_ != null) {
            return true;
        }
        if (!player.m_21205_().m_150930_((Item)ModItems.KINETIC_ILLUMINATOR.get())) {
            return true;
        }
        CameraType pov = client.f_91066_.m_92176_();
        return pov == CameraType.THIRD_PERSON_FRONT;
    }
}

