/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createkineticilluminator.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.kvnmtz.createkineticilluminator.client.CreateKineticIlluminatorClient;
import dev.kvnmtz.createkineticilluminator.client.renderer.KineticIlluminatorRenderHandler;
import dev.kvnmtz.createkineticilluminator.registry.ModPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KineticIlluminatorShootPacket
extends BaseS2CMessage {
    public final Vec3 barrelPos;
    public final InteractionHand usedHand;
    public final boolean self;
    public final BlockPos targetPos;
    public final ShootType shootType;

    public KineticIlluminatorShootPacket(Vec3 barrelPos, InteractionHand usedHand, boolean self, BlockPos targetPos, ShootType shootType) {
        this.barrelPos = barrelPos;
        this.usedHand = usedHand;
        this.self = self;
        this.targetPos = targetPos;
        this.shootType = shootType;
    }

    public KineticIlluminatorShootPacket(FriendlyByteBuf buf) {
        this.barrelPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.usedHand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.self = buf.readBoolean();
        this.targetPos = buf.m_130135_();
        this.shootType = buf.readBoolean() ? ShootType.PLACE_BLOCK : ShootType.DESTROY_BLOCK;
    }

    public MessageType getType() {
        return ModPackets.SHOOT_PACKET;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.barrelPos.f_82479_);
        buf.writeDouble(this.barrelPos.f_82480_);
        buf.writeDouble(this.barrelPos.f_82481_);
        buf.writeBoolean(this.usedHand == InteractionHand.MAIN_HAND);
        buf.writeBoolean(this.self);
        buf.m_130064_(this.targetPos);
        buf.writeBoolean(this.shootType == ShootType.PLACE_BLOCK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Entity cameraEntity = Minecraft.m_91087_().m_91288_();
            if (cameraEntity == null) {
                return;
            }
            if (cameraEntity.m_20182_().m_82554_(this.barrelPos) > 100.0) {
                return;
            }
            KineticIlluminatorRenderHandler handler = CreateKineticIlluminatorClient.KINETIC_ILLUMINATOR_RENDER_HANDLER;
            handler.addBeam(new KineticIlluminatorRenderHandler.PhotonBeam(this.barrelPos, this.targetPos.m_252807_(), this.shootType));
            if (this.self) {
                handler.shoot(this.usedHand, this.barrelPos);
                handler.playSound(this.barrelPos, this.shootType);
            } else {
                handler.playSound(this.barrelPos, this.shootType);
            }
        });
    }

    public static enum ShootType {
        PLACE_BLOCK,
        DESTROY_BLOCK;

    }
}

