/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.missingandnewpotions.block;

import io.netty.buffer.Unpooled;
import net.mcreator.missingandnewpotions.block.entity.CandyBasketBlockEntity;
import net.mcreator.missingandnewpotions.world.inventory.CandyBasketGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public class CandyBasketBlock
extends Block
implements EntityBlock {
    public CandyBasketBlock(BlockBehaviour.Properties properties) {
        super(properties.sound((SoundType)new DeferredSoundType(1.0f, 1.0f, () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.wood.break")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.wood.step")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.wood.place")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.wood.hit")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.wood.fall")))).instabreak().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)CandyBasketBlock.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{CandyBasketBlock.box((double)0.0, (double)1.0, (double)4.0, (double)1.0, (double)6.0, (double)12.0), CandyBasketBlock.box((double)15.0, (double)1.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0), CandyBasketBlock.box((double)1.0, (double)1.0, (double)11.0, (double)15.0, (double)6.0, (double)12.0), CandyBasketBlock.box((double)6.0, (double)6.0, (double)11.0, (double)7.0, (double)11.0, (double)12.0), CandyBasketBlock.box((double)9.0, (double)6.0, (double)11.0, (double)10.0, (double)11.0, (double)12.0), CandyBasketBlock.box((double)9.0, (double)6.0, (double)4.0, (double)10.0, (double)11.0, (double)5.0), CandyBasketBlock.box((double)6.0, (double)6.0, (double)4.0, (double)7.0, (double)11.0, (double)5.0), CandyBasketBlock.box((double)6.0, (double)10.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0), CandyBasketBlock.box((double)9.0, (double)10.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0), CandyBasketBlock.box((double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)6.0, (double)5.0)});
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Candy Basket");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new CandyBasketGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CandyBasketBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity be = (CandyBasketBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

