/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.missingandnewpotions.init;

import net.mcreator.missingandnewpotions.entity.BlackHoleEntity;
import net.mcreator.missingandnewpotions.entity.FireBottleEntity;
import net.mcreator.missingandnewpotions.entity.GhostEntity;
import net.mcreator.missingandnewpotions.entity.MimicPumpkinEntity;
import net.mcreator.missingandnewpotions.entity.MoonRabbitEntity;
import net.mcreator.missingandnewpotions.entity.TrashCanoEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class MissingAndNewPotionsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"missing_and_new_potions");
    public static final DeferredHolder<EntityType<?>, EntityType<MoonRabbitEntity>> MOON_RABBIT = MissingAndNewPotionsModEntities.register("moon_rabbit", EntityType.Builder.of(MoonRabbitEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<TrashCanoEntity>> TRASH_CANO = MissingAndNewPotionsModEntities.register("trash_cano", EntityType.Builder.of(TrashCanoEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(80).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlackHoleEntity>> BLACK_HOLE = MissingAndNewPotionsModEntities.register("black_hole", EntityType.Builder.of(BlackHoleEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<FireBottleEntity>> FIRE_BOTTLE = MissingAndNewPotionsModEntities.register("fire_bottle", EntityType.Builder.of(FireBottleEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<MimicPumpkinEntity>> MIMIC_PUMPKIN = MissingAndNewPotionsModEntities.register("mimic_pumpkin", EntityType.Builder.of(MimicPumpkinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<GhostEntity>> GHOST = MissingAndNewPotionsModEntities.register("ghost", EntityType.Builder.of(GhostEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"missing_and_new_potions", (String)registryname))));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)TRASH_CANO.get(), (living, context) -> living.getCombinedInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)MIMIC_PUMPKIN.get(), (living, context) -> living.getCombinedInventory());
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MoonRabbitEntity.init(event);
        TrashCanoEntity.init(event);
        BlackHoleEntity.init(event);
        MimicPumpkinEntity.init(event);
        GhostEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MOON_RABBIT.get(), MoonRabbitEntity.createAttributes().build());
        event.put((EntityType)TRASH_CANO.get(), TrashCanoEntity.createAttributes().build());
        event.put((EntityType)BLACK_HOLE.get(), BlackHoleEntity.createAttributes().build());
        event.put((EntityType)MIMIC_PUMPKIN.get(), MimicPumpkinEntity.createAttributes().build());
        event.put((EntityType)GHOST.get(), GhostEntity.createAttributes().build());
    }
}

