/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.missingandnewpotions.network;

import net.mcreator.missingandnewpotions.MissingAndNewPotionsMod;
import net.mcreator.missingandnewpotions.procedures.Back6Procedure;
import net.mcreator.missingandnewpotions.procedures.Down6Procedure;
import net.mcreator.missingandnewpotions.procedures.Front6Procedure;
import net.mcreator.missingandnewpotions.procedures.Left6Procedure;
import net.mcreator.missingandnewpotions.procedures.NormalProcedure;
import net.mcreator.missingandnewpotions.procedures.Right6Procedure;
import net.mcreator.missingandnewpotions.procedures.Up6Procedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record AmuletOf6SidedGravityGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AmuletOf6SidedGravityGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"missing_and_new_potions", (String)"amulet_of_6_sided_gravity_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AmuletOf6SidedGravityGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new AmuletOf6SidedGravityGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<AmuletOf6SidedGravityGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(AmuletOf6SidedGravityGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> AmuletOf6SidedGravityGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Right6Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Up6Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Left6Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            Down6Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Front6Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            Back6Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            NormalProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MissingAndNewPotionsMod.addNetworkMessage(TYPE, STREAM_CODEC, AmuletOf6SidedGravityGUIButtonMessage::handleData);
    }
}

