/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.missingandnewpotions.recipe.brewing;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber
public class UncraftblePotionRecipeBrewingRecipe
implements IBrewingRecipe {
    @SubscribeEvent
    public static void init(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addRecipe((IBrewingRecipe)new UncraftblePotionRecipeBrewingRecipe());
    }

    public boolean isInput(ItemStack input) {
        Item inputItem = input.getItem();
        return (inputItem == Items.POTION || inputItem == Items.SPLASH_POTION || inputItem == Items.LINGERING_POTION) && ((PotionContents)input.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER);
    }

    public boolean isIngredient(ItemStack ingredient) {
        return Ingredient.of((ItemLike)Blocks.ENCHANTING_TABLE.asItem()).test(ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            return new ItemStack((ItemLike)Items.POTION);
        }
        return ItemStack.EMPTY;
    }
}

